"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TmnWrapper = void 0;
const lodash_1 = require("lodash");
const neon_core_1 = require("@cityofzion/neon-core");
const api_1 = require("./api");
const DEFAULT_OPTIONS = {
    node: 'http://localhost:50012',
    scriptHash: '0x904fd053ba2542d3941f309485792d151c3a88be'
};
class TmnWrapper {
    constructor(options = {}) {
        this.networkMagic = -1;
        this.options = lodash_1.merge({}, DEFAULT_OPTIONS, options);
    }
    async init() {
        const getVersionRes = await this.node.getVersion();
        this.networkMagic = getVersionRes.protocol.network;
    }
    get node() {
        if (this.options.node) {
            return new neon_core_1.rpc.RPCClient(this.options.node);
        }
        throw new Error('no node selected!');
    }
    get scriptHash() {
        if (this.options.scriptHash) {
            return this.options.scriptHash;
        }
        throw new Error('node scripthash defined');
    }
    async balanceOf(address, signer) {
        return api_1.TMNAPI.balanceOf(this.node.url, this.networkMagic, this.scriptHash, address, signer);
    }
    async decimals(signer) {
        return api_1.TMNAPI.decimals(this.node.url, this.networkMagic, this.scriptHash, signer);
    }
    async mint(target, signer) {
        return api_1.TMNAPI.mint(this.node.url, this.networkMagic, this.scriptHash, target, signer);
    }
    async symbol(signer) {
        return api_1.TMNAPI.symbol(this.node.url, this.networkMagic, this.scriptHash, signer);
    }
    async totalSupply(signer) {
        return api_1.TMNAPI.totalSupply(this.node.url, this.networkMagic, this.scriptHash, signer);
    }
    async transfer(fromAccount, toAddress, amount) {
        return api_1.TMNAPI.transfer(this.node.url, this.networkMagic, this.scriptHash, fromAccount.address, toAddress, amount, fromAccount);
    }
}
exports.TmnWrapper = TmnWrapper;
//# sourceMappingURL=tmnWrapper.js.map