import { rpc, wallet } from '@cityofzion/neon-core';
import { MintType } from "./interface/interface";
export interface TMNWrapperOptions {
    node?: string;
    scriptHash?: string;
}
export declare class TmnWrapper {
    private options;
    private networkMagic;
    constructor(options?: TMNWrapperOptions);
    init(): Promise<void>;
    get node(): rpc.RPCClient;
    get scriptHash(): string;
    balanceOf(address: string, signer?: wallet.Account): Promise<number>;
    decimals(signer?: wallet.Account): Promise<number>;
    mint(target: MintType, signer: wallet.Account): Promise<string | undefined>;
    symbol(signer?: wallet.Account): Promise<string>;
    totalSupply(signer?: wallet.Account): Promise<number>;
    transfer(fromAccount: wallet.Account, toAddress: string, amount: number): Promise<boolean>;
}
