"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Nep17Wrapper = void 0;
const lodash_1 = require("lodash");
const neon_core_1 = require("@cityofzion/neon-core");
const api_1 = require("./api");
const DEFAULT_OPTIONS = {
    node: 'http://localhost:50012',
    //scriptHash: ''
};
class Nep17Wrapper {
    constructor(options = {}) {
        this.networkMagic = -1;
        this.options = lodash_1.merge({}, DEFAULT_OPTIONS, options);
    }
    async init() {
        const getVersionRes = await this.node.getVersion();
        this.networkMagic = getVersionRes.protocol.network;
    }
    get node() {
        if (this.options.node) {
            return new neon_core_1.rpc.RPCClient(this.options.node);
        }
        throw new Error('no node selected!');
    }
    get scriptHash() {
        if (this.options.scriptHash) {
            return this.options.scriptHash;
        }
        throw new Error('node scripthash defined');
    }
    async balanceOf(address) {
        return api_1.Nep17.balanceOf(this.node.url, this.networkMagic, this.scriptHash, address);
    }
    async decimals() {
        return api_1.Nep17.decimals(this.node.url, this.networkMagic, this.scriptHash);
    }
    async mint(meta, royalties, data, account) {
        return api_1.Nep17.mint(this.node.url, this.networkMagic, this.scriptHash, account.address, meta, royalties, data, account);
    }
    async symbol() {
        return api_1.Nep17.symbol(this.node.url, this.networkMagic, this.scriptHash);
    }
    async totalSupply() {
        return api_1.Nep17.totalSupply(this.node.url, this.networkMagic, this.scriptHash);
    }
    async transfer(fromAccount, toAddress, amount) {
        return api_1.Nep17.transfer(this.node.url, this.networkMagic, this.scriptHash, fromAccount.address, toAddress, amount, fromAccount);
    }
}
exports.Nep17Wrapper = Nep17Wrapper;
//# sourceMappingURL=nep17Wrapper.js.map