import { rpc, wallet } from '@cityofzion/neon-core';
export interface Nep17WrapperOptions {
    node?: string;
    scriptHash?: string;
}
export declare class Nep17Wrapper {
    private options;
    private networkMagic;
    constructor(options?: Nep17WrapperOptions);
    init(): Promise<void>;
    get node(): rpc.RPCClient;
    get scriptHash(): string;
    balanceOf(address: string): Promise<number>;
    decimals(): Promise<number>;
    mint(meta: string, royalties: string, data: string, account: wallet.Account): Promise<string | undefined>;
    symbol(): Promise<string>;
    totalSupply(): Promise<number>;
    transfer(fromAccount: wallet.Account, toAddress: string, amount: number): Promise<boolean>;
}
