"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TMNAPI = void 0;
const neon_js_1 = require("@cityofzion/neon-js");
const helpers_1 = require("../helpers");
class TMNAPI {
    /**
     * Returns the token symbol
     * @param node
     * @param networkMagic
     * @param contractHash
     */
    static async symbol(node, networkMagic, contractHash, signer) {
        const method = "symbol";
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, [], signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res[0]);
    }
    /**
     * Returns the decimals of the token
     * @param node
     * @param networkMagic
     * @param contractHash
     */
    static async decimals(node, networkMagic, contractHash, signer) {
        const method = "decimals";
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, [], signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res[0]);
    }
    /**
     * Returns the total supply of the token
     * @param node
     * @param networkMagic
     * @param contractHash
     */
    static async totalSupply(node, networkMagic, contractHash, signer) {
        const method = "totalSupply";
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, [], signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res[0]);
    }
    /**
     * Returns the balance of an account
     * @param node
     * @param networkMagic
     * @param contractHash
     * @param address
     */
    static async balanceOf(node, networkMagic, contractHash, address, signer) {
        const method = "balanceOf";
        const params = [neon_js_1.sc.ContractParam.hash160(address)];
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, params, signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res[0]);
    }
    /**
     * Executes a transfer invocation for the tokens.
     * @param node
     * @param networkMagic
     * @param contractHash
     * @param fromAddress
     * @param toAddress
     * @param amount
     * @param signer
     * @param data
     */
    static async transfer(node, networkMagic, contractHash, fromAddress, toAddress, amount, signer, data) {
        const method = "transfer";
        const params = [
            neon_js_1.sc.ContractParam.hash160(fromAddress),
            neon_js_1.sc.ContractParam.hash160(toAddress),
            amount,
            data,
        ];
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, params, signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res);
    }
    /**
     * Creates a new NEP11 token on the contract
     * @param node
     * @param networkMagic
     * @param contractHash
     * @param address The address to mint to.
     * @param amount: the amount to mint
     * @param signer: the signing account for the transaction
     */
    static async mint(node, networkMagic, contractHash, target, signer) {
        const method = "mint";
        const params = [
            neon_js_1.sc.ContractParam.hash160(target.address),
            neon_js_1.sc.ContractParam.integer(target.amount)
        ];
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, params, signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res);
    }
    static async mintBatch(node, networkMagic, contractHash, targets, signer) {
        const method = "mint_batch";
        const formatted = targets.map((entry) => {
            const params = [
                neon_js_1.sc.ContractParam.hash160(entry.address),
                neon_js_1.sc.ContractParam.integer(entry.amount)
            ];
            return neon_js_1.sc.ContractParam.array(...params);
        });
        const params = [
            neon_js_1.sc.ContractParam.array(...formatted)
        ];
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, params, signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res);
    }
    static async deploy(node, networkMagic, contractHash, signer) {
        const method = "deploy";
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, [], signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res);
    }
    static async getUserJSON(node, networkMagic, contractHash, address, signer) {
        const method = "get_user_json";
        const params = [
            neon_js_1.sc.ContractParam.hash160(address)
        ];
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, params, signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res[0]);
    }
    static async setUserPermission(node, networkMagic, contractHash, address, permission, value, signer) {
        const method = "set_user_permission";
        const params = [
            neon_js_1.sc.ContractParam.hash160(address),
            neon_js_1.sc.ContractParam.string(permission),
            neon_js_1.sc.ContractParam.boolean(value)
        ];
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, params, signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res);
    }
    static async totalAccounts(node, networkMagic, contractHash, signer) {
        const method = "total_accounts";
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, [], signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res[0]);
    }
    static async update(node, networkMagic, contractHash, script, manifest, data, signer) {
        const method = "update";
        const params = [
            neon_js_1.sc.ContractParam.byteArray(script),
            neon_js_1.sc.ContractParam.string(manifest),
            neon_js_1.sc.ContractParam.any(data)
        ];
        const res = await helpers_1.variableInvoke(node, networkMagic, contractHash, method, params, signer);
        if (signer) {
            return res;
        }
        return helpers_1.formatter(res);
    }
}
exports.TMNAPI = TMNAPI;
//# sourceMappingURL=tmn.js.map