import { wallet } from "@cityofzion/neon-core";
import { MintType } from "../interface";
export declare class TMNAPI {
    /**
     * Returns the token symbol
     * @param node
     * @param networkMagic
     * @param contractHash
     */
    static symbol(node: string, networkMagic: number, contractHash: string, signer?: wallet.Account): Promise<string>;
    /**
     * Returns the decimals of the token
     * @param node
     * @param networkMagic
     * @param contractHash
     */
    static decimals(node: string, networkMagic: number, contractHash: string, signer?: wallet.Account): Promise<number>;
    /**
     * Returns the total supply of the token
     * @param node
     * @param networkMagic
     * @param contractHash
     */
    static totalSupply(node: string, networkMagic: number, contractHash: string, signer?: wallet.Account): Promise<number>;
    /**
     * Returns the balance of an account
     * @param node
     * @param networkMagic
     * @param contractHash
     * @param address
     */
    static balanceOf(node: string, networkMagic: number, contractHash: string, address: string, signer?: wallet.Account): Promise<number>;
    /**
     * Executes a transfer invocation for the tokens.
     * @param node
     * @param networkMagic
     * @param contractHash
     * @param fromAddress
     * @param toAddress
     * @param amount
     * @param signer
     * @param data
     */
    static transfer(node: string, networkMagic: number, contractHash: string, fromAddress: string, toAddress: string, amount: number, signer: wallet.Account, data?: any): Promise<any>;
    /**
     * Creates a new NEP11 token on the contract
     * @param node
     * @param networkMagic
     * @param contractHash
     * @param address The address to mint to.
     * @param amount: the amount to mint
     * @param signer: the signing account for the transaction
     */
    static mint(node: string, networkMagic: number, contractHash: string, target: MintType, signer: wallet.Account): Promise<string>;
    static mintBatch(node: string, networkMagic: number, contractHash: string, targets: MintType[], signer: wallet.Account): Promise<string>;
    static deploy(node: string, networkMagic: number, contractHash: string, signer: wallet.Account): Promise<any>;
    static getUserJSON(node: string, networkMagic: number, contractHash: string, address: string, signer?: wallet.Account): Promise<any>;
    static setUserPermission(node: string, networkMagic: number, contractHash: string, address: string, permission: string, value: boolean, signer: wallet.Account): Promise<string>;
    static totalAccounts(node: string, networkMagic: number, contractHash: string, signer?: wallet.Account): Promise<number | string>;
    static update(node: string, networkMagic: number, contractHash: string, script: string, manifest: string, data: any, signer: wallet.Account): Promise<string>;
}
