"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Nep17 = void 0;
const interface_1 = require("./interface");
const neon_js_1 = __importStar(require("@cityofzion/neon-js"));
class Nep17 {
    /**
     * Returns the token symbol
     * @param node
     * @param networkMagic
     * @param contractHash
     */
    static async symbol(node, networkMagic, contractHash) {
        const method = "symbol";
        const res = await interface_1.NeoInterface.testInvoke(node, networkMagic, contractHash, method, []);
        if (res === undefined) {
            throw new Error("unrecognized response");
        }
        return neon_js_1.default.u.HexString.fromBase64(res[0].value).toAscii();
    }
    /**
     * Returns the decimals of the token
     * @param node
     * @param networkMagic
     * @param contractHash
     */
    static async decimals(node, networkMagic, contractHash) {
        const method = "decimals";
        const res = await interface_1.NeoInterface.testInvoke(node, networkMagic, contractHash, method, []);
        if (res === undefined) {
            throw new Error("unrecognized response");
        }
        return parseInt(res[0].value);
    }
    /**
     * Returns the total supply of the token
     * @param node
     * @param networkMagic
     * @param contractHash
     */
    static async totalSupply(node, networkMagic, contractHash) {
        const method = "totalSupply";
        const res = await interface_1.NeoInterface.testInvoke(node, networkMagic, contractHash, method, []);
        if (res === undefined || res.length === 0) {
            throw new Error("unrecognized response");
        }
        return parseInt(res[0].value);
    }
    /**
     * Returns the balance of an account
     * @param node
     * @param networkMagic
     * @param contractHash
     * @param address
     */
    static async balanceOf(node, networkMagic, contractHash, address) {
        const method = "balanceOf";
        const params = [neon_js_1.sc.ContractParam.hash160(address)];
        const res = await interface_1.NeoInterface.testInvoke(node, networkMagic, contractHash, method, params);
        if (res === undefined || res.length === 0) {
            throw new Error("unrecognized response");
        }
        return parseInt(res[0].value);
    }
    /**
     * Executes a transfer invocation for the tokens.
     * @param node
     * @param networkMagic
     * @param contractHash
     * @param fromAddress
     * @param toAddress
     * @param amount
     * @param signer
     * @param data
     */
    static async transfer(node, networkMagic, contractHash, fromAddress, toAddress, amount, signer, data) {
        const method = "transfer";
        const params = [
            neon_js_1.sc.ContractParam.hash160(fromAddress),
            neon_js_1.sc.ContractParam.hash160(toAddress),
            amount,
            data,
        ];
        return await interface_1.NeoInterface.publishInvoke(node, networkMagic, contractHash, method, params, signer);
    }
    /**
     * Creates a new NEP11 token on the contract
     * @param node
     * @param networkMagic
     * @param contractHash
     * @param address The address to mint to.
     * @param amount: the amount to mint
     * @param signer: the signing account for the transaction
     */
    static async mint(node, networkMagic, contractHash, address, amount, signer) {
        const method = "mint";
        const params = [
            neon_js_1.sc.ContractParam.hash160(address),
            neon_js_1.sc.ContractParam.integer(amount)
        ];
        return await interface_1.NeoInterface.publishInvoke(node, networkMagic, contractHash, method, params, signer);
    }
    static async mintBatch(node, networkMagic, contractHash, targets, signer) {
        const method = "mint_batch";
        const formatted = targets.map((entry) => {
            const params = [
                neon_js_1.sc.ContractParam.hash160(entry.address),
                neon_js_1.sc.ContractParam.integer(entry.amount)
            ];
            return neon_js_1.sc.ContractParam.array(...params);
        });
        const params = [
            neon_js_1.sc.ContractParam.array(...formatted)
        ];
        return await interface_1.NeoInterface.publishInvoke(node, networkMagic, contractHash, method, params, signer);
    }
}
exports.Nep17 = Nep17;
//# sourceMappingURL=nep17.js.map