"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TMN = void 0;
const lodash_1 = require("lodash");
const neon_core_1 = require("@cityofzion/neon-core");
const api_1 = require("./api");
const neon_js_1 = require("@cityofzion/neon-js");
const DEFAULT_OPTIONS = {
    node: 'http://localhost:50012',
    scriptHash: '0x10c3d1730b957139e81941d036ef5c6699c320b5'
};
class TMN {
    constructor(options = {}) {
        this.networkMagic = -1;
        this.options = lodash_1.merge({}, DEFAULT_OPTIONS, options);
    }
    async init() {
        const getVersionRes = await this.node.getVersion();
        this.networkMagic = getVersionRes.protocol.network;
    }
    get node() {
        if (this.options.node) {
            return new neon_core_1.rpc.RPCClient(this.options.node);
        }
        throw new Error('no node selected!');
    }
    get scriptHash() {
        if (this.options.scriptHash) {
            return this.options.scriptHash;
        }
        throw new Error('node scripthash defined');
    }
    async balanceOf(address, signer) {
        return api_1.TMNAPI.balanceOf(this.node.url, this.networkMagic, this.scriptHash, address, signer);
    }
    async decimals(signer) {
        return api_1.TMNAPI.decimals(this.node.url, this.networkMagic, this.scriptHash, signer);
    }
    async deploy(signer) {
        return api_1.TMNAPI.deploy(this.node.url, this.networkMagic, this.scriptHash, signer);
    }
    async getUserJSON(address, signer) {
        return api_1.TMNAPI.getUserJSON(this.node.url, this.networkMagic, this.scriptHash, address, signer);
    }
    async mint(target, signer) {
        return api_1.TMNAPI.mint(this.node.url, this.networkMagic, this.scriptHash, target, signer);
    }
    async mintBatch(targets, signer) {
        return api_1.TMNAPI.mintBatch(this.node.url, this.networkMagic, this.scriptHash, targets, signer);
    }
    async setUserPermission(address, permission, value, signer) {
        return api_1.TMNAPI.setUserPermission(this.node.url, this.networkMagic, this.scriptHash, address, permission, value, signer);
    }
    async symbol(signer) {
        return api_1.TMNAPI.symbol(this.node.url, this.networkMagic, this.scriptHash, signer);
    }
    async totalAccounts(signer) {
        return api_1.TMNAPI.totalAccounts(this.node.url, this.networkMagic, this.scriptHash, signer);
    }
    async totalSupply(signer) {
        return api_1.TMNAPI.totalSupply(this.node.url, this.networkMagic, this.scriptHash, signer);
    }
    async transfer(fromAccount, toAddress, amount) {
        return api_1.TMNAPI.transfer(this.node.url, this.networkMagic, this.scriptHash, fromAccount.address, toAddress, amount, fromAccount);
    }
    async update(script, manifest, signer) {
        return api_1.TMNAPI.update(this.node.url, this.networkMagic, this.scriptHash, script, manifest, '', signer);
    }
    async arbitraryTransfer(scriptHash, fromAccount, toAddress, amount) {
        const params = [
            neon_js_1.sc.ContractParam.hash160(fromAccount.address),
            neon_js_1.sc.ContractParam.hash160(toAddress),
            neon_js_1.sc.ContractParam.integer(amount),
            neon_js_1.sc.ContractParam.any()
        ];
        return api_1.NeoInterface.publishInvoke(this.node.url, this.networkMagic, scriptHash, "transfer", params, fromAccount);
    }
}
exports.TMN = TMN;
//# sourceMappingURL=TMN.js.map