import { rpc, wallet } from '@cityofzion/neon-core';
import { MintType } from "./interface";
export interface TMNWrapperOptions {
    node?: string;
    scriptHash?: string;
}
export declare class TMN {
    private options;
    private networkMagic;
    constructor(options?: TMNWrapperOptions);
    init(): Promise<void>;
    get node(): rpc.RPCClient;
    get scriptHash(): string;
    balanceOf(address: string, signer?: wallet.Account): Promise<number>;
    decimals(signer?: wallet.Account): Promise<number>;
    deploy(signer: wallet.Account): Promise<number>;
    getUserJSON(address: string, signer?: wallet.Account): Promise<any>;
    mint(target: MintType, signer: wallet.Account): Promise<string>;
    mintBatch(targets: MintType[], signer: wallet.Account): Promise<string>;
    setUserPermission(address: string, permission: string, value: boolean, signer: wallet.Account): Promise<string>;
    symbol(signer?: wallet.Account): Promise<string>;
    totalAccounts(signer?: wallet.Account): Promise<string | number>;
    totalSupply(signer?: wallet.Account): Promise<number>;
    transfer(fromAccount: wallet.Account, toAddress: string, amount: number): Promise<boolean>;
    update(script: string, manifest: string, signer: wallet.Account): Promise<string | undefined>;
    arbitraryTransfer(scriptHash: string, fromAccount: wallet.Account, toAddress: string, amount: number): Promise<string | undefined>;
}
