const sdk = require('../sdk_ts/dist')
const fs = require('fs')
const Neon = require("@cityofzion/neon-core")

const TIME_CONSTANT = 4000

async function main(node, signer) {

    const tmn = await new sdk.TMN({node: node})
    await tmn.init()

    console.log(`Configuring the contract at ${tmn.scriptHash}`)
    const txid = await tmn.deploy(signer)

    await sdk.helpers.sleep(TIME_CONSTANT)

    const res = await sdk.helpers.txDidComplete(node, txid, true)
    if (res[0] === 0) {
        throw new Error("Initialization failed, contract may already be initialized")
    }
    console.log("Contract initialized!")
}


const network = JSON.parse(fs.readFileSync("default.neo-express").toString());
const node = process.argv[2] || 'http://localhost'
const pkey = process.argv[3] || network.wallets[0].accounts[0]['private-key']
const signer = new Neon.wallet.Account(pkey)

main(node, signer)