const Neon = require("@cityofzion/neon-core")
const sdk = require('../sdk_ts/dist')
const fs = require('fs')

async function main(node, pathToNEF, privateKey) {
    ///console.log("in main");
    const rpcNode = new Neon.rpc.RPCClient(node)
    //console.log("in after cleints");
    const getVersionRes = await rpcNode.getVersion()
        /////console.log("get version res");

    const networkMagic = getVersionRes.protocol.network
    ///console.log("after network magic");
    const txid = await sdk.helpers.deployContract(node, networkMagic, pathToNEF, privateKey)
    ///console.log("after txid "+txid);
    await sleep(5000)
    ///console.log("after await 5000");
    const res = await sdk.helpers.txDidComplete(node, txid, true)
    console.log(res)
}

const network = JSON.parse(fs.readFileSync("default.neo-express").toString());
const node = process.argv[2] || 'http://localhost:50012'
const pkey = process.argv[3] || network.wallets[0].accounts[0]['private-key']
console.log(" after pkey "+ pkey);
const signer = new Neon.wallet.Account(pkey)

main(node,
    'contract/tmn/tmn.nef',
    signer)

function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}