/* eslint-disable @typescript-eslint/no-explicit-any */
import * as api from "@cityofzion/neon-api";
import * as neonCore from "@cityofzion/neon-core";
import * as experimental from "./experimental";
const { sc, rpc, wallet, CONST, u, tx, logging } = neonCore;
/**
 * Semantic path for creation of a resource.
 */
const create = {
    account: (k) => new wallet.Account(k),
    privateKey: wallet.generatePrivateKey,
    signature: wallet.generateSignature,
    wallet: (k) => new wallet.Wallet(k),
    contractParam: (type, value) => sc.ContractParam.fromJson({ type, value }),
    script: sc.createScript,
    scriptBuilder: () => new sc.ScriptBuilder(),
    rpcClient: (net) => new rpc.RPCClient(net),
    query: (req) => new rpc.Query(req),
    network: (net) => new rpc.Network(net),
    stringStream: (str) => new u.StringStream(str),
};
/**
 * Semantic path for verification of a type.
 */
const is = {
    address: wallet.isAddress,
    publicKey: wallet.isPublicKey,
    encryptedKey: wallet.isNEP2,
    privateKey: wallet.isPrivateKey,
    wif: wallet.isWIF,
    scriptHash: wallet.isScriptHash,
};
/**
 * Semantic path for deserialization of object.
 */
const deserialize = {
    attribute: tx.TransactionAttribute.deserialize,
    script: tx.Witness.deserialize,
    tx: tx.Transaction.deserialize,
};
/**
 * Semantic path for signing using private key.
 */
const sign = {
    hex: wallet.sign,
    message: (msg, privateKey) => {
        const hex = u.str2hexstring(msg);
        return wallet.sign(hex, privateKey);
    },
};
/**
 * Semantic path for verifying signatures using public key.
 */
const verify = {
    hex: wallet.verify,
    message: (msg, sig, publicKey) => {
        const hex = u.str2hexstring(msg);
        return wallet.verify(hex, sig, publicKey);
    },
};
export default {
    create,
    deserialize,
    is,
    sign,
    verify,
    encrypt: {
        privateKey: wallet.encrypt,
    },
    decrypt: {
        privateKey: wallet.decrypt,
    },
    u,
    CONST,
    experimental,
};
export { experimental, api, sc, rpc, wallet, CONST, u, tx, logging };
//# sourceMappingURL=index.js.map