import * as api from "@cityofzion/neon-api";
import * as neonCore from "@cityofzion/neon-core";
import * as experimental from "./experimental";
declare const sc: typeof neonCore.sc, rpc: typeof neonCore.rpc, wallet: typeof neonCore.wallet, CONST: typeof neonCore.CONST, u: typeof neonCore.u, tx: typeof neonCore.tx, logging: typeof neonCore.logging;
declare const _default: {
    create: {
        account: (k: string) => neonCore.wallet.Account;
        privateKey: typeof neonCore.wallet.generatePrivateKey;
        signature: typeof neonCore.wallet.generateSignature;
        wallet: (k: neonCore.wallet.WalletJSON) => neonCore.wallet.Wallet;
        contractParam: (type: "Any" | "Boolean" | "Integer" | "ByteArray" | "String" | "Hash160" | "Hash256" | "PublicKey" | "Signature" | "Array" | "Map" | "InteropInterface" | "Void", value?: string | number | boolean | neonCore.sc.ContractParamJson[] | null | undefined) => neonCore.sc.ContractParam;
        script: typeof neonCore.sc.createScript;
        scriptBuilder: () => neonCore.sc.ScriptBuilder;
        rpcClient: (net: string) => neonCore.rpc.RPCClient;
        query: (req: neonCore.rpc.QueryLike<unknown[]>) => neonCore.rpc.Query<unknown[], unknown>;
        network: (net: Partial<neonCore.rpc.NetworkJSON>) => neonCore.rpc.Network;
        stringStream: (str?: string | undefined) => neonCore.u.StringStream;
    };
    deserialize: {
        attribute: typeof neonCore.tx.TransactionAttribute.deserialize;
        script: typeof neonCore.tx.Witness.deserialize;
        tx: typeof neonCore.tx.Transaction.deserialize;
    };
    is: {
        address: typeof neonCore.wallet.isAddress;
        publicKey: typeof neonCore.wallet.isPublicKey;
        encryptedKey: typeof neonCore.wallet.isNEP2;
        privateKey: typeof neonCore.wallet.isPrivateKey;
        wif: typeof neonCore.wallet.isWIF;
        scriptHash: typeof neonCore.wallet.isScriptHash;
    };
    sign: {
        hex: typeof neonCore.wallet.sign;
        message: (msg: string, privateKey: string) => string;
    };
    verify: {
        hex: typeof neonCore.wallet.verify;
        message: (msg: string, sig: string, publicKey: string) => boolean;
    };
    encrypt: {
        privateKey: typeof neonCore.wallet.encrypt;
    };
    decrypt: {
        privateKey: typeof neonCore.wallet.decrypt;
    };
    u: typeof neonCore.u;
    CONST: typeof neonCore.CONST;
    experimental: typeof experimental;
};
export default _default;
export { experimental, api, sc, rpc, wallet, CONST, u, tx, logging };
//# sourceMappingURL=index.d.ts.map