import { rpc, u } from "@cityofzion/neon-core";
import { CommonConfig } from "../types";
export declare class Nep17Contract {
    /**
     * Base class for communicating with NEP-5 contracts on the block chain.
     */
    contractHash: u.HexString;
    protected config: CommonConfig;
    protected rpcClient: rpc.RPCClient;
    private _decimals?;
    private _name?;
    private _symbol?;
    constructor(contractHash: u.HexString, config: CommonConfig);
    /**
     * Get the number of tokens owned by NEO address
     */
    balanceOf(address: string): Promise<number>;
    /**
     * Get the number of decimals the token can have
     */
    decimals(): Promise<number>;
    /**
     * Get the human readable name of the token
     */
    name(): Promise<string>;
    /**
     * Get the abbreviated name of the token.
     * Often used to represent the token in exchanges
     */
    symbol(): Promise<string>;
    /**
     * Get the total amount of tokens deployed to the system
     *
     * Note: this is not the same as the total freely available tokens for exchanging.
     * A certain amount might be locked in the contract until a specific release date.
     */
    totalSupply(): Promise<number>;
    /**
     * Move tokens from one address to another
     * @param from - source NEO address
     * @param to - destination NEO address
     * @param amount - quantity of tokens to send
     */
    transfer(from: string, to: string, amount: number): Promise<string>;
}
export declare class NEOContract extends Nep17Contract {
    /**
     * Convenience class initializing a Nep17Contract to the NEO token
     * exposing additional claim functions
     * @param config -
     */
    constructor(config: CommonConfig);
    /**
     * Move tokens from one address to another
     * @param from - source NEO address
     * @param to - destination NEO address
     * @param amount - quantity of tokens to send
     */
    transfer(from: string, to: string, amount: number): Promise<string>;
    /**
     * Claim gas for address
     * @param address - NEO address
     * @returns transaction id
     */
    claimGas(address: string): Promise<string>;
    /**
     * Get the available bonus GAS for address
     * @param address - NEO address
     */
    getUnclaimedGas(address: string): Promise<number>;
}
export declare class GASContract extends Nep17Contract {
    /**
     * Convenience class initializing a Nep17Contract to GAS token
     * @param config -
     */
    constructor(config: CommonConfig);
}
//# sourceMappingURL=base.d.ts.map