import { sc, tx, u, wallet } from "@cityofzion/neon-core";
import { CommonConfig } from "./types";
/**
 * Calculate the GAS costs for validation and inclusion of the transaction in a block
 * @param transaction - the transaction to calculate the network fee for
 * @param account -
 * @param config -
 */
export declare function calculateNetworkFee(transaction: tx.Transaction, account: wallet.Account, config: CommonConfig): Promise<u.BigInteger>;
/**
 * Get the cost of executing the smart contract script
 * @param script - smart contract script
 * @param config -
 * @param signers - signers to set while running the script
 */
export declare function getSystemFee(script: u.HexString, config: CommonConfig, signers?: tx.Signer[]): Promise<u.BigInteger>;
/**
 * Set the validUntilBlock field on a transaction
 *
 * If `blocksTillExpiry` is provided then the value is used.
 * If `blocksTillExpiry` is not provided, or the value exceeds the maximum allowed,
 * then the field is automatically set to the maximum allowed by the network.
 * @param transaction - the transaction to set the expiry field on
 * @param config -
 * @param blocksTillExpiry - number of blocks from the current chain height until the transaction is no longer valid
 */
export declare function setBlockExpiry(transaction: tx.Transaction, config: CommonConfig, blocksTillExpiry?: number): Promise<void>;
/**
 * Add system and network fees to a transaction.
 * Validates that the source Account has sufficient balance
 * @param transaction - the transaction to add network and system fees to
 * @param config -
 * @param token_decimals -
 */
export declare function addFees(transaction: tx.Transaction, config: CommonConfig): Promise<void>;
/**
 * Deploy a smart contract
 * @param nef - A smart contract in Neo executable file format. Commonly created by a NEO compiler and stored as .NEF on disk
 * @param manifest - the manifest corresponding to the smart contract
 * @param config -
 */
export declare function deployContract(nef: sc.NEF, manifest: sc.ContractManifest, config: CommonConfig): Promise<string>;
/**
 * Get the hash that identifies the contract on the chain matching the specified NEF
 * @param sender - The sender of the transaction
 * @param nefChecksum - The checksum of the Neo Executable File. A NEF file is a smart contract commonly created by a NEO compiler and stored as .NEF on disk
 * @param contractName - The name as indicated in the manifest
 */
export declare function getContractHash(sender: u.HexString, nefChecksum: number, contractName: string): string;
//# sourceMappingURL=helpers.d.ts.map