import { CommonConfig } from "./types";
import { rpc, tx, sc, u } from "@cityofzion/neon-core";
export declare class SmartContract {
    /**
     * A class for communicating with smart contracts on the block chain.
     */
    contractHash: u.HexString;
    protected config: CommonConfig;
    protected rpcClient: rpc.RPCClient;
    constructor(contractHash: u.HexString, config: CommonConfig);
    /**
     * Run a test invocation on the smart contract.
     *
     * Note: The results are not persisted to the blockchain. To persist use `invoke` instead.
     * @param operation - name of operation to call
     * @param params - parameters to pass
     * @param signers - script hashes of witnesses that should sign the transaction containing this script
     */
    testInvoke(operation: string, params?: sc.ContractParam[], signers?: tx.Signer[]): Promise<rpc.InvokeResult>;
    /**
     * Run an invocation on the smart contract.
     * Requires the contract to be created with a valid CommonConfig.account
     *
     * Note:
     * - results are persisted to the blockchain.
     * - currently only supports Sender as signer
     * Tip: use `testInvoke` for querying data without needing to pay GAS.
     * @param operation - name of operation to call
     * @param params - parameters to pass.
     * @param signers - custom list of signers to add to the transaction. It is up
     * to the user to ensure that the sender is the first signer.
     * @returns transaction id
     */
    invoke(operation: string, params?: sc.ContractParam[], signers?: tx.Signer[]): Promise<string>;
}
//# sourceMappingURL=contract.d.ts.map