/**
 * Generates a ECDSA signature from a hexstring using the given private key.
 * @param hex - hexstring to hash.
 * @param privateKey - hexstring or WIF format.
 * @param k - optional nonce for generating a signature. Providing this value will cause the signature generated to be deterministic.
 * @returns a 64 byte hexstring made from (r+s)
 */
export declare function sign(hex: string, privateKey: string, k?: number | string): string;
/**
 * Verifies that the message, signature and signing key matches.
 * @param hex - message that was signed.
 * @param sig - ECDSA signature in the form of a 64 byte hexstring (r+s).
 * @param publicKey - encoded/unencoded public key of the signing key.
 */
export declare function verify(hex: string, sig: string, publicKey: string): boolean;
/**
 * Generates a signature of the transaction based on given private key.
 * @param tx - serialized unsigned transaction
 * @param privateKey - private Key
 * @returns Signature. Does not include tx.
 *
 * @deprecated please use sign(tx, privateKey).
 */
export declare function generateSignature(tx: string, privateKey: string): string;
//# sourceMappingURL=signing.d.ts.map