/**
 * Constructs the script for a multi-sig account.
 * @param signingThreshold - number of keys required for signing. Must be smaller or equal to the number of keys provided.
 * @param keys - public keys of all keys involved. Ordering matters.
 */
export declare function constructMultiSigVerificationScript(signingThreshold: number, keys: string[]): string;
/**
 * Returns the list of public keys found in the verification script.
 * @param verificationScript - verification Script of an Account.
 */
export declare function getPublicKeysFromVerificationScript(verificationScript: string): string[];
/**
 * Returns the number of signatures required for signing for a verification Script.
 * @param verificationScript - verification script of a multi-sig Account.
 */
export declare function getSigningThresholdFromVerificationScript(verificationScript: string): number;
/**
 * Extract signatures from invocationScript
 * @param invocationScript - invocationScript of a Witness.
 */
export declare function getSignaturesFromInvocationScript(invocationScript: string): string[];
//# sourceMappingURL=multisig.d.ts.map