import { HexString } from "./HexString";
import { StringStream } from "./StringStream";
interface NeonSerializable {
    size: number;
    serialize: () => string;
}
declare type Serializables = number | HexString | NeonSerializable[];
/**
 * Calculates the byte size of any supported input following NEO's variable int format.
 */
export declare function getSerializedSize(value: Serializables): number;
export declare function deserializeArrayOf<T>(type: (ss: StringStream) => T, ss: StringStream): T[];
export declare function serializeArrayOf(prop: (NeonSerializable | string)[]): string;
export {};
//# sourceMappingURL=serialize.d.ts.map