import { ab2hexstring } from "./convert";
import { ensureHex } from "./basic";
/**
 * XORs two hexstrings
 *
 * @param str1 - HEX string
 * @param str2 - HEX string
 * @returns XOR output as a HEX string
 */
export function hexXor(str1, str2) {
    ensureHex(str1);
    ensureHex(str2);
    if (str1.length !== str2.length) {
        throw new Error(`strings are disparate lengths. Inputs are of length ${str1.length} and ${str2.length}`);
    }
    const result = [];
    for (let i = 0; i < str1.length; i += 2) {
        result.push(
        // tslint:disable-next-line:no-bitwise
        parseInt(str1.substr(i, 2), 16) ^ parseInt(str2.substr(i, 2), 16));
    }
    return ab2hexstring(result);
}
/**
 * Reverses an array.
 *
 * @example
 * reverseArray('abcd') = 'dcba'
 */
export function reverseArray(arr) {
    if (typeof arr !== "object" || !arr.length) {
        throw new Error("reverseArray expects an array");
    }
    const result = new Array(arr.length);
    for (let i = 0; i < arr.length; i++) {
        result[i] = arr[arr.length - 1 - i];
    }
    return result;
}
//# sourceMappingURL=misc.js.map