/**
 * Converts an ArrayBuffer to an ASCII string.
 */
export declare function ab2str(buf: ArrayBuffer | ArrayLike<number>): string;
/**
 * Converts an ASCII string into an arrayBuffer.
 */
export declare function str2ab(str: string): Uint8Array;
/**
 * Converts a hexstring into an arrayBuffer.
 */
export declare function hexstring2ab(str: string): Uint8Array;
/**
 * Converts an arraybuffer to hexstring.
 */
export declare function ab2hexstring(arr: ArrayBuffer | ArrayLike<number>): string;
/**
 * Converts an ascii string to hexstring.
 */
export declare function str2hexstring(str: string): string;
/**
 * Converts a hexstring to ascii string.
 */
export declare function hexstring2str(hexstring: string): string;
/**
 * convert an integer to big endian hex and add leading zeros.
 */
export declare function int2hex(num: number): string;
/**
 * Converts a number to a big endian hexstring of a suitable size, optionally little endian
 * @param num - a positive integer.
 * @param size - the required size in bytes, eg 1 for Uint8, 2 for Uint16. Defaults to 1.
 * @param littleEndian - encode the hex in little endian form
 */
export declare function num2hexstring(num: number, size?: number, littleEndian?: boolean): string;
/**
 * Converts a number to a variable length Int. Used for array length header
 */
export declare function num2VarInt(num: number): string;
//# sourceMappingURL=convert.d.ts.map