export declare class HexString {
    #private;
    get length(): number;
    get byteLength(): number;
    assert(value: string): void;
    /**
     * Initiate a HexString
     * @param value - a string that contains only [1-9a-f]. Can be prefixed with 0x.
     * @param littleEndian - indicate whether value is little endian or not. default to be false.
     */
    protected constructor(value: string, littleEndian?: boolean);
    toString(): string;
    /**
     * Export as big endian string
     */
    toBigEndian(): string;
    /**
     * Export as little endian string
     */
    toLittleEndian(): string;
    /**
     * Returns a new HexString with internal value reversed hex.
     */
    reversed(): HexString;
    /**
     * Judge if 2 HexString are equal
     */
    equals(other: HexString | string): boolean;
    /**
     * XOR with another HexString to get a new one.
     */
    xor(other: HexString): HexString;
    /**
     * Export as ASCII string
     */
    toAscii(): string;
    /**
     * Export as number
     * @param asLittleEndian - whether export as little endian number, default to be false
     */
    toNumber(asLittleEndian?: boolean): number;
    /**
     * Export to ArrayBuffer in Uint8Array
     * @param asLittleEndian - whether export as little endian array, default to be false
     */
    toArrayBuffer(asLittleEndian?: boolean): Uint8Array;
    /**
     * Export as a base64-encoded string.
     * @param asLittleEndian - whether to encode as little endian, default to be false
     */
    toBase64(asLittleEndian?: boolean): string;
    /**
     * Get HexString instance from a hex string
     * @param str - hexstring
     * @param littleEndian - whether `str` is little endian
     */
    static fromHex(str: string, littleEndian: boolean): HexString;
    static fromHex(str: string | HexString): HexString;
    /**
     * Get HexString instance from a ASCII string
     */
    static fromAscii(str: string): HexString;
    /**
     * Get HexString instance from a number
     * @param littleEndian - whether `num` is little endian
     */
    static fromNumber(num: number): HexString;
    /**
     * Get HexString instance from array buffer
     * @param littleEndian - whether `arr` is little endian
     */
    static fromArrayBuffer(arr: ArrayBuffer | ArrayLike<number>, littleEndian?: boolean): HexString;
    /**
     * Get HexString instance from a Base64-encoded string
     * @param littleEndian - whether the decoded hexstring is little endian
     */
    static fromBase64(encodedString: string, littleEndian?: boolean): HexString;
}
//# sourceMappingURL=HexString.d.ts.map