import { StringStream, HexString } from "../../u";
import { Account } from "../../wallet";
import { NeonObject } from "../../model";
export interface WitnessLike {
    invocationScript: string;
    verificationScript: string;
}
export interface WitnessJson {
    invocation: string;
    verification: string;
}
/**
 * A Witness is a section of VM code that is ran during the verification of the transaction.
 *
 * For example, the most common witness is the VM Script that pushes the ECDSA signature into the VM and calling CHECKSIG to prove the authority to spend the TransactionInputs in the transaction.
 */
export declare class Witness implements NeonObject<WitnessLike> {
    #private;
    static deserialize(hex: string): Witness;
    static fromJson(input: WitnessJson): Witness;
    static fromStream(ss: StringStream): Witness;
    static fromSignature(sig: string, publicKey: string): Witness;
    /**
     * Builds a multi-sig Witness object.
     * @param tx - hexstring to be signed.
     * @param sigs - unordered list of signatures.
     * @param acctOrVerificationScript - account or verification script. Account needs to be the multi-sig account and not one of the public keys.
     */
    static buildMultiSig(tx: string, sigs: (string | Witness)[], acctOrVerificationScript: Account | string): Witness;
    invocationScript: HexString;
    verificationScript: HexString;
    constructor(obj?: Partial<Pick<WitnessLike | Witness, keyof WitnessLike>>);
    get size(): number;
    get scriptHash(): string;
    serialize(): string;
    export(): WitnessLike;
    toJson(): WitnessJson;
    equals(other: Partial<WitnessLike | Witness>): boolean;
    private generateScriptHash;
}
export default Witness;
//# sourceMappingURL=Witness.d.ts.map