import { StringStream, HexString } from "../../u";
import { TxAttrUsage } from "./txAttrUsage";
import { NeonObject } from "../../model";
export interface TransactionAttributeLike {
    usage: number | string;
    data: string | HexString;
}
export interface TransactionAttributeJson {
    usage: string;
    data: string;
}
export declare function toTxAttrUsage(type: TxAttrUsage | string | number): TxAttrUsage;
/**
 * An attribute that is used to decorate the transaction.
 * Used for appending additional information to the transaction.
 *
 * For example, a remark is attached as an attribute.
 */
export declare class TransactionAttribute implements NeonObject<TransactionAttributeLike> {
    static deserialize(hex: string): TransactionAttribute;
    static fromJson(input: TransactionAttributeJson): TransactionAttribute;
    static fromStream(ss: StringStream): TransactionAttribute;
    usage: TxAttrUsage;
    /**
     * data in hex format
     */
    data: HexString;
    constructor(obj?: Partial<TransactionAttributeLike | TransactionAttribute>);
    get size(): number;
    /**
     * Constructs a Url Attribute
     * @param url - URL string in ASCII
     */
    static Url(url: string): TransactionAttribute;
    get [Symbol.toStringTag](): string;
    serialize(): string;
    export(): TransactionAttributeLike;
    toJson(): TransactionAttributeJson;
    equals(other: Partial<TransactionAttributeLike | TransactionAttribute>): boolean;
}
export default TransactionAttribute;
//# sourceMappingURL=TransactionAttribute.d.ts.map