import { WitnessScope } from "./WitnessScope";
import { StringStream, HexString } from "../../u";
export interface SignerLike {
    account: string | HexString;
    scopes: number | string | WitnessScope;
    allowedContracts?: (string | HexString)[];
    allowedGroups?: (string | HexString)[];
}
export interface SignerJson {
    account: string;
    scopes: string;
    allowedcontracts?: string[];
    allowedgroups?: string[];
}
export declare class Signer {
    /**
     * scripthash of cosigner
     */
    account: HexString;
    scopes: WitnessScope;
    /**
     * List of scripthashes of allowed contracts. Only present when WitnessScope.CustomContracts is present in scopes.
     */
    allowedContracts: HexString[];
    /**
     * List of public keys of allowed groups. Only present when WitnessScope.CustomGroups is present in scopes.
     */
    allowedGroups: HexString[];
    static fromJson(input: SignerJson): Signer;
    constructor(signer?: Partial<SignerLike | Signer>);
    /**
     * Returns the number of bytes this object will take when serialized.
     */
    get size(): number;
    addAllowedContracts(...contracts: string[]): void;
    addAllowedGroups(...groups: string[]): void;
    static deserialize(ss: StringStream): Signer;
    /**
     * Merges the other Signer into this signer.
     * Deduplicates contracts and groups.
     * Modifies the original Signer and returns it.
     */
    merge(other: SignerLike | Signer): this;
    serialize(): string;
    export(): SignerLike;
    toJson(): SignerJson;
}
export default Signer;
//# sourceMappingURL=Signer.d.ts.map