export interface ContractPermissionLike {
    contract: string;
    methods: "*" | string[];
}
export interface ContractPermissionJson {
    /**
     * 0x-prefixed contract hash (42 characters), public key (66 characters) or '*'.
     */
    contract: string;
    methods: "*" | string[];
}
export declare class ContractPermission {
    /**
     * Contract hash (40 characters), public key (66 characters) or '*'
     */
    contract: string;
    methods: "*" | string[];
    /**
     *  Parses a ContractPermissionDescriptor.
     * @param jsonDescriptor - descriptor found in JSON format.
     * @returns a sanitized string
     */
    static parseJsonDescriptor(jsonDescriptor: string): string;
    /**
     * Converts an internal ContractPermissionDescriptor to JSON format.
     * @param descriptor - internal ContractPermissionDescriptor string
     * @returns JSON formatted string
     */
    static toJsonDescriptor(descriptor: string): string;
    fromJson(json: ContractPermissionJson): ContractPermission;
    constructor(obj?: Partial<ContractPermissionLike>);
    get isHash(): boolean;
    get isGroup(): boolean;
    get isWildcard(): boolean;
    toJson(): ContractPermissionJson;
    export(): ContractPermissionLike;
}
//# sourceMappingURL=ContractPermission.d.ts.map