import { ContractParamType } from "../ContractParam";
import { parseEnum } from "../../internal";
export class ContractMethodDefinition {
    constructor(obj) {
        const { name = "", offset = 0, parameters = [], returnType = ContractParamType.Any, safe = false, } = obj;
        this.name = name;
        this.offset = offset;
        this.parameters = [...parameters];
        this.returnType = returnType;
        this.safe = safe;
    }
    static fromJson(json) {
        return new ContractMethodDefinition({
            name: json.name,
            offset: json.offset,
            parameters: json.parameters.map((p) => ({
                name: p.name,
                type: parseEnum(p.type, ContractParamType),
            })),
            returnType: parseEnum(json.returntype, ContractParamType),
            safe: json.safe,
        });
    }
    toJson() {
        return {
            name: this.name,
            offset: this.offset,
            parameters: this.parameters.map((p) => ({
                name: p.name,
                type: ContractParamType[p.type],
            })),
            returntype: ContractParamType[this.returnType],
            safe: this.safe,
        };
    }
    export() {
        return {
            name: this.name,
            offset: this.offset,
            parameters: [...this.parameters],
            returnType: this.returnType,
            safe: this.safe,
        };
    }
}
//# sourceMappingURL=ContractMethodDefinition.js.map