import { ContractGroup, } from "./ContractGroup";
import { ContractAbi } from "./ContractAbi";
import { ContractPermission, } from "./ContractPermission";
export class ContractManifest {
    constructor(obj) {
        const { name = "", groups = [], features = {}, abi = {}, supportedStandards = [], permissions = [], trusts = "*", extra, } = obj;
        this.name = name;
        this.groups = groups.map((group) => new ContractGroup(group));
        this.features = features;
        this.supportedStandards = supportedStandards;
        this.abi = new ContractAbi(abi);
        this.permissions = permissions.map((permission) => new ContractPermission(permission));
        this.trusts = Array.isArray(trusts)
            ? trusts.map((t) => ContractPermission.parseJsonDescriptor(t))
            : trusts;
        this.extra = extra;
    }
    static fromJson(json) {
        if (Object.keys(json.features).length != 0) {
            throw new Error("Features is reserved for future use and must be empty");
        }
        return new ContractManifest({
            name: json.name,
            groups: json.groups.map((g) => ContractGroup.fromJson(g)),
            features: {},
            abi: ContractAbi.fromJson(json.abi),
            supportedStandards: json.supportedstandards,
            permissions: json.permissions,
            trusts: json.trusts,
            extra: json.extra,
        });
    }
    toJson() {
        return {
            name: this.name,
            groups: this.groups.map((g) => g.toJson()),
            features: this.features,
            supportedstandards: this.supportedStandards,
            abi: this.abi.toJson(),
            permissions: this.permissions.map((p) => p.toJson()),
            trusts: Array.isArray(this.trusts)
                ? this.trusts.map((t) => ContractPermission.toJsonDescriptor(t))
                : this.trusts,
            extra: this.extra,
        };
    }
    export() {
        return {
            name: this.name,
            groups: this.groups.map((group) => group.export()),
            features: this.features,
            supportedStandards: this.supportedStandards,
            abi: this.abi.export(),
            permissions: this.permissions.map((permission) => permission.export()),
            trusts: this.trusts,
            extra: this.extra,
        };
    }
}
ContractManifest.MAX_LENGTH = 0xffff;
export default ContractManifest;
//# sourceMappingURL=ContractManifest.js.map