import { ContractGroup, ContractGroupLike, ContractGroupJson } from "./ContractGroup";
import { ContractAbi, ContractAbiLike, ContractAbiJson } from "./ContractAbi";
import { ContractPermission, ContractPermissionLike, ContractPermissionJson } from "./ContractPermission";
export interface ContractManifestLike {
    name: string;
    groups: ContractGroupLike[];
    features: Record<string, unknown>;
    abi: ContractAbiLike;
    supportedStandards: string[];
    permissions: ContractPermissionLike[];
    trusts: "*" | string[];
    extra?: unknown;
}
export interface ContractManifestJson {
    name: string;
    groups: ContractGroupJson[];
    features: Record<string, unknown>;
    supportedstandards: string[];
    abi: ContractAbiJson;
    permissions: ContractPermissionJson[];
    trusts: "*" | string[];
    extra?: unknown;
}
export declare class ContractManifest {
    static readonly MAX_LENGTH = 65535;
    name: string;
    groups: ContractGroup[];
    features: Record<string, unknown>;
    supportedStandards: string[];
    abi: ContractAbi;
    permissions: ContractPermission[];
    trusts: "*" | string[];
    extra: unknown;
    static fromJson(json: ContractManifestJson): ContractManifest;
    constructor(obj: Partial<ContractManifestLike>);
    toJson(): ContractManifestJson;
    export(): ContractManifestLike;
}
export default ContractManifest;
//# sourceMappingURL=ContractManifest.d.ts.map