import { HexString } from "../../u";
export class ContractGroup {
    constructor(obj) {
        const { pubKey = "", signature = "" } = obj;
        this.pubKey = pubKey;
        this.signature = signature;
    }
    static fromJson(json) {
        return new ContractGroup({
            pubKey: json.pubkey,
            signature: HexString.fromBase64(json.signature).toBigEndian(),
        });
    }
    toJson() {
        return {
            pubkey: this.pubKey,
            signature: HexString.fromHex(this.signature).toBase64(),
        };
    }
    export() {
        return {
            pubKey: this.pubKey,
            signature: this.signature,
        };
    }
}
//# sourceMappingURL=ContractGroup.js.map