import { parseEnum } from "../../internal";
import { ContractParamType } from "../ContractParam";
export class ContractEventDefiniton {
    constructor(obj) {
        const { name = "", parameters = [] } = obj;
        this.name = name;
        this.parameters = [...parameters];
    }
    static fromJson(json) {
        return new ContractEventDefiniton({
            name: json.name,
            parameters: json.parameters.map((p) => ({
                name: p.name,
                type: parseEnum(p.type, ContractParamType),
            })),
        });
    }
    toJson() {
        return {
            name: this.name,
            parameters: this.parameters.map((p) => ({
                name: p.name,
                type: ContractParamType[p.type],
            })),
        };
    }
    export() {
        return {
            name: this.name,
            parameters: [...this.parameters],
        };
    }
}
//# sourceMappingURL=ContractEventDefiniton.js.map