import { ContractMethodDefinition, } from "./ContractMethodDefinition";
import { ContractEventDefiniton, } from "./ContractEventDefiniton";
export class ContractAbi {
    constructor(obj) {
        const { methods = [], events = [] } = obj;
        this.methods = methods.map((method) => new ContractMethodDefinition(method));
        this.events = events.map((event) => new ContractEventDefiniton(event));
    }
    static fromJson(json) {
        return new ContractAbi({
            methods: json.methods.map((m) => ContractMethodDefinition.fromJson(m)),
            events: json.events.map((e) => ContractEventDefiniton.fromJson(e)),
        });
    }
    toJson() {
        return {
            methods: this.methods.map((m) => m.toJson()),
            events: this.events.map((e) => e.toJson()),
        };
    }
    export() {
        return {
            methods: this.methods.map((method) => method.export()),
            events: this.events.map((event) => event.export()),
        };
    }
}
//# sourceMappingURL=ContractAbi.js.map