import { ScriptBuilder } from "./ScriptBuilder";
/**
 * Translates a ScriptIntent / array of ScriptIntents into hexstring.
 * @param scripts - ContractCall or hexstrings.
 */
export function createScript(...scripts) {
    const sb = new ScriptBuilder();
    for (const script of scripts) {
        if (typeof script === "string") {
            sb.str += script;
            continue;
        }
        const contractCall = script;
        if (!contractCall.scriptHash) {
            throw new Error("No scriptHash found!");
        }
        if (!contractCall.operation) {
            throw new Error("No operation found!");
        }
        sb.emitContractCall(script);
    }
    return sb.build();
}
//# sourceMappingURL=core.js.map