import { ContractMethodDefinition } from "../manifest/ContractMethodDefinition";
import { BaseContract } from "./BaseContract";
import policyAbi from "./templates/PolicyTemplateAbi.json";
import { NATIVE_CONTRACT_HASH } from "../../consts";
let SINGLETON;
/**
 * Policy Contract that contains block-specific parameters for the current blockchain.
 * Helper methods are not fully implemented but the complete definition is available.
 */
export class PolicyContract extends BaseContract {
    static get INSTANCE() {
        if (!SINGLETON) {
            SINGLETON = new PolicyContract();
        }
        return SINGLETON;
    }
    static getMethods() {
        return policyAbi.methods.map((m) => ContractMethodDefinition.fromJson(m));
    }
    constructor() {
        super(NATIVE_CONTRACT_HASH.PolicyContract, PolicyContract.getMethods());
    }
    getFeePerByte() {
        return this.call("getFeePerByte");
    }
    getExecFeeFactor() {
        return this.call("getExecFeeFactor");
    }
}
//# sourceMappingURL=PolicyContract.js.map