import { BigInteger } from "../../u";
import { ContractMethodDefinition } from "../manifest/ContractMethodDefinition";
import { ContractCall } from "../types";
import { BaseContract } from "./BaseContract";
/**
 * A standard NEP-17 contract according to specification.
 */
export declare class Nep17Contract extends BaseContract {
    /**
     * The list of methods found on the NEP-5 specification.
     */
    static getMethods(): ContractMethodDefinition[];
    constructor(scriptHash: string, additionalMethods?: ContractMethodDefinition[]);
    symbol(): ContractCall;
    decimals(): ContractCall;
    /**
     * Retrieves the balance of the address.
     * The balance returned will be an integer which needs to be processed according to the number of decimals for this token.
     *
     * @param address - The address to enquire.
     *
     * @example
     * const contract = new Nep17Contract(contractHash);
     * const balanceOfCall = contract.balanceOf(address);
     * const result =
     */
    balanceOf(address: string): ContractCall;
    totalSupply(): ContractCall;
    /**
     * Transfers some token between addresses.
     * The amount of tokens needs to be
     * @param from - The address from where the funds originate.
     * @param to - The address where the funds will arrive at.
     * @param amount - The amount of tokens to transfer in integer format.
     */
    transfer(from: string, to: string, amount: string | number | BigInteger, data?: string): ContractCall;
}
//# sourceMappingURL=Nep17Contract.d.ts.map