import { NATIVE_CONTRACT_HASH } from "../../consts";
import { ContractParam } from "../ContractParam";
import { ContractMethodDefinition } from "../manifest";
import { Nep17Contract } from "./Nep17Contract";
import neoAbi from "./templates/NeoTemplateAbi.json";
let SINGLETON;
export class NeoContract extends Nep17Contract {
    static get INSTANCE() {
        if (!SINGLETON) {
            SINGLETON = new NeoContract();
        }
        return SINGLETON;
    }
    /**
     * The list of methods found on the NEO contract.
     */
    static getMethods() {
        return neoAbi.methods.map((m) => ContractMethodDefinition.fromJson(m));
    }
    constructor() {
        super(NATIVE_CONTRACT_HASH.NeoToken, NeoContract.getMethods());
    }
    unclaimedGas(address, end) {
        return this.call("unclaimedGas", ContractParam.hash160(address), ContractParam.integer(end));
    }
    getCandidates() {
        return this.call("getCandidates");
    }
    getRegisterPrice() {
        return this.call("getRegisterPrice");
    }
    registerCandidate(publicKey) {
        return this.call("registerCandidate", ContractParam.publicKey(publicKey));
    }
    vote(address, voteTo) {
        return this.call("vote", ContractParam.hash160(address), ContractParam.publicKey(voteTo));
    }
}
//# sourceMappingURL=NeoContract.js.map