import { BigInteger, HexString } from "../../u";
import { ContractMethodDefinition } from "../manifest";
import { ContractCall } from "../types";
import { Nep17Contract } from "./Nep17Contract";
export declare class NeoContract extends Nep17Contract {
    static get INSTANCE(): NeoContract;
    /**
     * The list of methods found on the NEO contract.
     */
    static getMethods(): ContractMethodDefinition[];
    constructor();
    unclaimedGas(address: string, end: number | BigInteger): ContractCall;
    getCandidates(): ContractCall;
    getRegisterPrice(): ContractCall;
    registerCandidate(publicKey: string | HexString): ContractCall;
    vote(address: string, voteTo: string | HexString): ContractCall;
}
//# sourceMappingURL=NeoContract.d.ts.map