import { NATIVE_CONTRACT_HASH } from "../../consts";
import { ContractMethodDefinition } from "../manifest";
import { Nep17Contract } from "./Nep17Contract";
import gasAbi from "./templates/GasTemplateAbi.json";
let SINGLETON;
export class GasContract extends Nep17Contract {
    static get INSTANCE() {
        if (!SINGLETON) {
            SINGLETON = new GasContract();
        }
        return SINGLETON;
    }
    /**
     * The list of methods found on the GAS contract.
     */
    static getMethods() {
        return gasAbi.methods.map((m) => ContractMethodDefinition.fromJson(m));
    }
    constructor() {
        super(NATIVE_CONTRACT_HASH.GasToken, GasContract.getMethods());
    }
}
//# sourceMappingURL=GasContract.js.map