import ContractParam, { ContractParamJson } from "../ContractParam";
import { ContractMethodDefinition } from "../manifest";
import { ContractCall } from "../types";
export declare class BaseContract {
    #private;
    get scriptHash(): string;
    /**
     * Getter for retrieving the ABI for this contract.
     * This is made readonly with Typescript. This has no effect in Javascript.
     */
    get methods(): Readonly<Record<string, ContractMethodDefinition>>;
    constructor(scriptHash: string, methods?: ContractMethodDefinition[]);
    call(method: ContractMethodDefinition | string, ...inputArgs: (string | boolean | number | ContractParam | ContractParamJson)[]): ContractCall;
}
//# sourceMappingURL=BaseContract.d.ts.map