export declare enum StackItemType {
    Any = 0,
    Pointer = 16,
    Boolean = 32,
    Integer = 33,
    ByteString = 40,
    Buffer = 48,
    Array = 64,
    Struct = 65,
    Map = 72,
    InteropInterface = 96
}
export declare type StackItemValue = string | boolean | number | StackItem[] | StackItemMap[];
export interface StackItemLike {
    type: StackItemType | keyof typeof StackItemType | number;
    value: string | boolean | number | StackItemLike[] | StackItemMapLike[];
}
export interface StackItemJson {
    type: keyof typeof StackItemType;
    value?: string | boolean | number | StackItemJson[];
}
export interface StackItemMapLike {
    key: StackItem | StackItemLike;
    value: StackItem | StackItemLike;
}
export interface StackItemMap {
    key: StackItem;
    value: StackItem;
}
/**
 * Determine if there's a nested set based on type
 */
export declare function hasChildren(type: StackItemType): boolean;
/**
 * Object returned as a result of executing a script in the VM.
 */
export declare class StackItem {
    type: StackItemType;
    value: string | boolean | number | StackItem[] | StackItemMap[];
    constructor(obj: Partial<StackItemLike>);
    export(): StackItemLike;
}
export default StackItem;
//# sourceMappingURL=StackItem.d.ts.map