export var OpCode;
(function (OpCode) {
    /* Constants */
    OpCode[OpCode["PUSHINT8"] = 0] = "PUSHINT8";
    OpCode[OpCode["PUSHINT16"] = 1] = "PUSHINT16";
    OpCode[OpCode["PUSHINT32"] = 2] = "PUSHINT32";
    OpCode[OpCode["PUSHINT64"] = 3] = "PUSHINT64";
    OpCode[OpCode["PUSHINT128"] = 4] = "PUSHINT128";
    OpCode[OpCode["PUSHINT256"] = 5] = "PUSHINT256";
    // Convert the next four bytes to an address, and push the address onto the stack.
    OpCode[OpCode["PUSHA"] = 10] = "PUSHA";
    // The item <see langword="null"/> is pushed onto the stack.
    OpCode[OpCode["PUSHNULL"] = 11] = "PUSHNULL";
    // The next byte contains the number of bytes to be pushed onto the stack.
    OpCode[OpCode["PUSHDATA1"] = 12] = "PUSHDATA1";
    // The next two bytes contain the number of bytes to be pushed onto the stack.
    OpCode[OpCode["PUSHDATA2"] = 13] = "PUSHDATA2";
    // The next four bytes contain the number of bytes to be pushed onto the stack.
    OpCode[OpCode["PUSHDATA4"] = 14] = "PUSHDATA4";
    // The number -1 is pushed onto the stack.
    OpCode[OpCode["PUSHM1"] = 15] = "PUSHM1";
    // The number 0 is pushed onto the stack.
    OpCode[OpCode["PUSH0"] = 16] = "PUSH0";
    // The number 1 is pushed onto the stack.
    OpCode[OpCode["PUSH1"] = 17] = "PUSH1";
    // The number 2 is pushed onto the stack.
    OpCode[OpCode["PUSH2"] = 18] = "PUSH2";
    // The number 3 is pushed onto the stack.
    OpCode[OpCode["PUSH3"] = 19] = "PUSH3";
    // The number 4 is pushed onto the stack.
    OpCode[OpCode["PUSH4"] = 20] = "PUSH4";
    // The number 5 is pushed onto the stack.
    OpCode[OpCode["PUSH5"] = 21] = "PUSH5";
    // The number 6 is pushed onto the stack.
    OpCode[OpCode["PUSH6"] = 22] = "PUSH6";
    // The number 7 is pushed onto the stack.
    OpCode[OpCode["PUSH7"] = 23] = "PUSH7";
    // The number 8 is pushed onto the stack.
    OpCode[OpCode["PUSH8"] = 24] = "PUSH8";
    // The number 9 is pushed onto the stack.
    OpCode[OpCode["PUSH9"] = 25] = "PUSH9";
    // The number 10 is pushed onto the stack.
    OpCode[OpCode["PUSH10"] = 26] = "PUSH10";
    // The number 11 is pushed onto the stack.
    OpCode[OpCode["PUSH11"] = 27] = "PUSH11";
    // The number 12 is pushed onto the stack.
    OpCode[OpCode["PUSH12"] = 28] = "PUSH12";
    // The number 13 is pushed onto the stack.
    OpCode[OpCode["PUSH13"] = 29] = "PUSH13";
    // The number 14 is pushed onto the stack.
    OpCode[OpCode["PUSH14"] = 30] = "PUSH14";
    // The number 15 is pushed onto the stack.
    OpCode[OpCode["PUSH15"] = 31] = "PUSH15";
    // The number 16 is pushed onto the stack.
    OpCode[OpCode["PUSH16"] = 32] = "PUSH16";
    /* Flow control */
    // The operation does nothing. It is intended to fill in space if opcodes are patched.
    OpCode[OpCode["NOP"] = 33] = "NOP";
    // Unconditionally transfers control to a target instruction. The target instruction is represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMP"] = 34] = "JMP";
    // Unconditionally transfers control to a target instruction. The target instruction is represented as a 4-bytes signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMP_L"] = 35] = "JMP_L";
    // Transfers control to a target instruction if the value is <see langword="true"/>, not <see langword="null"/>, or non-zero. The target instruction is represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPIF"] = 36] = "JMPIF";
    // Transfers control to a target instruction if the value is <see langword="true"/>, not <see langword="null"/>, or non-zero. The target instruction is represented as a 4-bytes signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPIF_L"] = 37] = "JMPIF_L";
    // Transfers control to a target instruction if the value is <see langword="false"/>, a <see langword="null"/> reference, or zero. The target instruction is represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPIFNOT"] = 38] = "JMPIFNOT";
    // Transfers control to a target instruction if the value is <see langword="false"/>, a <see langword="null"/> reference, or zero. The target instruction is represented as a 4-bytes signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPIFNOT_L"] = 39] = "JMPIFNOT_L";
    // Transfers control to a target instruction if two values are equal. The target instruction is represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPEQ"] = 40] = "JMPEQ";
    // Transfers control to a target instruction if two values are equal. The target instruction is represented as a 4-bytes signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPEQ_L"] = 41] = "JMPEQ_L";
    // Transfers control to a target instruction when two values are not equal. The target instruction is represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPNE"] = 42] = "JMPNE";
    // Transfers control to a target instruction when two values are not equal. The target instruction is represented as a 4-bytes signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPNE_L"] = 43] = "JMPNE_L";
    // Transfers control to a target instruction if the first value is greater than the second value. The target instruction is represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPGT"] = 44] = "JMPGT";
    // Transfers control to a target instruction if the first value is greater than the second value. The target instruction is represented as a 4-bytes signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPGT_L"] = 45] = "JMPGT_L";
    // Transfers control to a target instruction if the first value is greater than or equal to the second value. The target instruction is represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPGE"] = 46] = "JMPGE";
    // Transfers control to a target instruction if the first value is greater than or equal to the second value. The target instruction is represented as a 4-bytes signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPGE_L"] = 47] = "JMPGE_L";
    // Transfers control to a target instruction if the first value is less than the second value. The target instruction is represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPLT"] = 48] = "JMPLT";
    // Transfers control to a target instruction if the first value is less than the second value. The target instruction is represented as a 4-bytes signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPLT_L"] = 49] = "JMPLT_L";
    // Transfers control to a target instruction if the first value is less than or equal to the second value. The target instruction is represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPLE"] = 50] = "JMPLE";
    // Transfers control to a target instruction if the first value is less than or equal to the second value. The target instruction is represented as a 4-bytes signed offset from the beginning of the current instruction.
    OpCode[OpCode["JMPLE_L"] = 51] = "JMPLE_L";
    // Calls the function at the target address which is represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["CALL"] = 52] = "CALL";
    // Calls the function at the target address which is represented as a 4-bytes signed offset from the beginning of the current instruction.
    OpCode[OpCode["CALL_L"] = 53] = "CALL_L";
    // Pop the address of a function from the stack, and call the function.
    OpCode[OpCode["CALLA"] = 54] = "CALLA";
    // Calls the function which is described by the token.
    OpCode[OpCode["CALLT"] = 55] = "CALLT";
    // It turns the vm state to FAULT immediately, and cannot be caught.
    OpCode[OpCode["ABORT"] = 56] = "ABORT";
    // Pop the top value of the stack, if it false, then exit vm execution and set vm state to FAULT.
    OpCode[OpCode["ASSERT"] = 57] = "ASSERT";
    // Pop the top value of the stack, and throw it.
    OpCode[OpCode["THROW"] = 58] = "THROW";
    // TRY CatchOffset(sbyte) FinallyOffset(sbyte). If there's no catch body, set CatchOffset 0. If there's no finally body, set FinallyOffset 0.
    OpCode[OpCode["TRY"] = 59] = "TRY";
    // TRY_L CatchOffset(int) FinallyOffset(int). If there's no catch body, set CatchOffset 0. If there's no finally body, set FinallyOffset 0.
    OpCode[OpCode["TRY_L"] = 60] = "TRY_L";
    // Ensures that the appropriate surrounding finally blocks are executed. And then unconditionally transfers control to the specific target instruction, represented as a 1-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["ENDTRY"] = 61] = "ENDTRY";
    // Ensures that the appropriate surrounding finally blocks are executed. And then unconditionally transfers control to the specific target instruction, represented as a 4-byte signed offset from the beginning of the current instruction.
    OpCode[OpCode["ENDTRY_L"] = 62] = "ENDTRY_L";
    // End finally, If no exception happen or be catched, vm will jump to the target instruction of ENDTRY/ENDTRY_L. Otherwise vm will rethrow the exception to upper layer.
    OpCode[OpCode["ENDFINALLY"] = 63] = "ENDFINALLY";
    // Returns from the current method.
    OpCode[OpCode["RET"] = 64] = "RET";
    // Calls to an interop service.
    OpCode[OpCode["SYSCALL"] = 65] = "SYSCALL";
    /* Stack */
    // Puts the number of stack items onto the stack.
    OpCode[OpCode["DEPTH"] = 67] = "DEPTH";
    // Removes the top stack item.
    OpCode[OpCode["DROP"] = 69] = "DROP";
    // Removes the second-to-top stack item.
    OpCode[OpCode["NIP"] = 70] = "NIP";
    // The item n back in the main stack is removed.
    OpCode[OpCode["XDROP"] = 72] = "XDROP";
    // Clear the stack
    OpCode[OpCode["CLEAR"] = 73] = "CLEAR";
    // Duplicates the top stack item.
    OpCode[OpCode["DUP"] = 74] = "DUP";
    // Copies the second-to-top stack item to the top.
    OpCode[OpCode["OVER"] = 75] = "OVER";
    // The item n back in the stack is copied to the top.
    OpCode[OpCode["PICK"] = 77] = "PICK";
    // The item at the top of the stack is copied and inserted before the second-to-top item.
    OpCode[OpCode["TUCK"] = 78] = "TUCK";
    // The top two items on the stack are swapped.
    OpCode[OpCode["SWAP"] = 80] = "SWAP";
    // The top three items on the stack are rotated to the left.
    OpCode[OpCode["ROT"] = 81] = "ROT";
    // The item n back in the stack is moved to the top.
    OpCode[OpCode["ROLL"] = 82] = "ROLL";
    // Reverse the order of the top 3 items on the stack.
    OpCode[OpCode["REVERSE3"] = 83] = "REVERSE3";
    // Reverse the order of the top 4 items on the stack.
    OpCode[OpCode["REVERSE4"] = 84] = "REVERSE4";
    // Pop the number N on the stack, and reverse the order of the top N items on the stack.
    OpCode[OpCode["REVERSEN"] = 85] = "REVERSEN";
    /* Slot */
    // Initialize the static field list for the current execution context.
    OpCode[OpCode["INITSSLOT"] = 86] = "INITSSLOT";
    // Initialize the argument slot and the local variable list for the current execution context.
    OpCode[OpCode["INITSLOT"] = 87] = "INITSLOT";
    // Loads the static field at index 0 onto the evaluation stack.
    OpCode[OpCode["LDSFLD0"] = 88] = "LDSFLD0";
    // Loads the static field at index 1 onto the evaluation stack.
    OpCode[OpCode["LDSFLD1"] = 89] = "LDSFLD1";
    // Loads the static field at index 2 onto the evaluation stack.
    OpCode[OpCode["LDSFLD2"] = 90] = "LDSFLD2";
    // Loads the static field at index 3 onto the evaluation stack.
    OpCode[OpCode["LDSFLD3"] = 91] = "LDSFLD3";
    // Loads the static field at index 4 onto the evaluation stack.
    OpCode[OpCode["LDSFLD4"] = 92] = "LDSFLD4";
    // Loads the static field at index 5 onto the evaluation stack.
    OpCode[OpCode["LDSFLD5"] = 93] = "LDSFLD5";
    // Loads the static field at index 6 onto the evaluation stack.
    OpCode[OpCode["LDSFLD6"] = 94] = "LDSFLD6";
    // Loads the static field at a specified index onto the evaluation stack. The index is represented as a 1-byte unsigned integer.
    OpCode[OpCode["LDSFLD"] = 95] = "LDSFLD";
    // Stores the value on top of the evaluation stack in the static field list at index 0.
    OpCode[OpCode["STSFLD0"] = 96] = "STSFLD0";
    // Stores the value on top of the evaluation stack in the static field list at index 1.
    OpCode[OpCode["STSFLD1"] = 97] = "STSFLD1";
    // Stores the value on top of the evaluation stack in the static field list at index 2.
    OpCode[OpCode["STSFLD2"] = 98] = "STSFLD2";
    // Stores the value on top of the evaluation stack in the static field list at index 3.
    OpCode[OpCode["STSFLD3"] = 99] = "STSFLD3";
    // Stores the value on top of the evaluation stack in the static field list at index 4.
    OpCode[OpCode["STSFLD4"] = 100] = "STSFLD4";
    // Stores the value on top of the evaluation stack in the static field list at index 5.
    OpCode[OpCode["STSFLD5"] = 101] = "STSFLD5";
    // Stores the value on top of the evaluation stack in the static field list at index 6.
    OpCode[OpCode["STSFLD6"] = 102] = "STSFLD6";
    // Stores the value on top of the evaluation stack in the static field list at a specified index. The index is represented as a 1-byte unsigned integer.
    OpCode[OpCode["STSFLD"] = 103] = "STSFLD";
    // Loads the local variable at index 0 onto the evaluation stack.
    OpCode[OpCode["LDLOC0"] = 104] = "LDLOC0";
    // Loads the local variable at index 1 onto the evaluation stack.
    OpCode[OpCode["LDLOC1"] = 105] = "LDLOC1";
    // Loads the local variable at index 2 onto the evaluation stack.
    OpCode[OpCode["LDLOC2"] = 106] = "LDLOC2";
    // Loads the local variable at index 3 onto the evaluation stack.
    OpCode[OpCode["LDLOC3"] = 107] = "LDLOC3";
    // Loads the local variable at index 4 onto the evaluation stack.
    OpCode[OpCode["LDLOC4"] = 108] = "LDLOC4";
    // Loads the local variable at index 5 onto the evaluation stack.
    OpCode[OpCode["LDLOC5"] = 109] = "LDLOC5";
    // Loads the local variable at index 6 onto the evaluation stack.
    OpCode[OpCode["LDLOC6"] = 110] = "LDLOC6";
    // Loads the local variable at a specified index onto the evaluation stack. The index is represented as a 1-byte unsigned integer.
    OpCode[OpCode["LDLOC"] = 111] = "LDLOC";
    // Stores the value on top of the evaluation stack in the local variable list at index 0.
    OpCode[OpCode["STLOC0"] = 112] = "STLOC0";
    // Stores the value on top of the evaluation stack in the local variable list at index 1.
    OpCode[OpCode["STLOC1"] = 113] = "STLOC1";
    // Stores the value on top of the evaluation stack in the local variable list at index 2.
    OpCode[OpCode["STLOC2"] = 114] = "STLOC2";
    // Stores the value on top of the evaluation stack in the local variable list at index 3.
    OpCode[OpCode["STLOC3"] = 115] = "STLOC3";
    // Stores the value on top of the evaluation stack in the local variable list at index 4.
    OpCode[OpCode["STLOC4"] = 116] = "STLOC4";
    // Stores the value on top of the evaluation stack in the local variable list at index 5.
    OpCode[OpCode["STLOC5"] = 117] = "STLOC5";
    // Stores the value on top of the evaluation stack in the local variable list at index 6.
    OpCode[OpCode["STLOC6"] = 118] = "STLOC6";
    // Stores the value on top of the evaluation stack in the local variable list at a specified index. The index is represented as a 1-byte unsigned integer.
    OpCode[OpCode["STLOC"] = 119] = "STLOC";
    // Loads the argument at index 0 onto the evaluation stack.
    OpCode[OpCode["LDARG0"] = 120] = "LDARG0";
    // Loads the argument at index 1 onto the evaluation stack.
    OpCode[OpCode["LDARG1"] = 121] = "LDARG1";
    // Loads the argument at index 2 onto the evaluation stack.
    OpCode[OpCode["LDARG2"] = 122] = "LDARG2";
    // Loads the argument at index 3 onto the evaluation stack.
    OpCode[OpCode["LDARG3"] = 123] = "LDARG3";
    // Loads the argument at index 4 onto the evaluation stack.
    OpCode[OpCode["LDARG4"] = 124] = "LDARG4";
    // Loads the argument at index 5 onto the evaluation stack.
    OpCode[OpCode["LDARG5"] = 125] = "LDARG5";
    // Loads the argument at index 6 onto the evaluation stack.
    OpCode[OpCode["LDARG6"] = 126] = "LDARG6";
    // Loads the argument at a specified index onto the evaluation stack. The index is represented as a 1-byte unsigned integer.
    OpCode[OpCode["LDARG"] = 127] = "LDARG";
    // Stores the value on top of the evaluation stack in the argument slot at index 0.
    OpCode[OpCode["STARG0"] = 128] = "STARG0";
    // Stores the value on top of the evaluation stack in the argument slot at index 1.
    OpCode[OpCode["STARG1"] = 129] = "STARG1";
    // Stores the value on top of the evaluation stack in the argument slot at index 2.
    OpCode[OpCode["STARG2"] = 130] = "STARG2";
    // Stores the value on top of the evaluation stack in the argument slot at index 3.
    OpCode[OpCode["STARG3"] = 131] = "STARG3";
    // Stores the value on top of the evaluation stack in the argument slot at index 4.
    OpCode[OpCode["STARG4"] = 132] = "STARG4";
    // Stores the value on top of the evaluation stack in the argument slot at index 5.
    OpCode[OpCode["STARG5"] = 133] = "STARG5";
    // Stores the value on top of the evaluation stack in the argument slot at index 6.
    OpCode[OpCode["STARG6"] = 134] = "STARG6";
    // Stores the value on top of the evaluation stack in the argument slot at a specified index. The index is represented as a 1-byte unsigned integer.
    OpCode[OpCode["STARG"] = 135] = "STARG";
    /* Splice */
    OpCode[OpCode["NEWBUFFER"] = 136] = "NEWBUFFER";
    OpCode[OpCode["MEMCPY"] = 137] = "MEMCPY";
    // Concatenates two strings.
    OpCode[OpCode["CAT"] = 139] = "CAT";
    // Returns a section of a string.
    OpCode[OpCode["SUBSTR"] = 140] = "SUBSTR";
    // Keeps only characters left of the specified point in a string.
    OpCode[OpCode["LEFT"] = 141] = "LEFT";
    // Keeps only characters right of the specified point in a string.
    OpCode[OpCode["RIGHT"] = 142] = "RIGHT";
    /* Bitwise logic */
    // Flips all of the bits in the input.
    OpCode[OpCode["INVERT"] = 144] = "INVERT";
    // Boolean and between each bit in the inputs.
    OpCode[OpCode["AND"] = 145] = "AND";
    // Boolean or between each bit in the inputs.
    OpCode[OpCode["OR"] = 146] = "OR";
    // Boolean exclusive or between each bit in the inputs.
    OpCode[OpCode["XOR"] = 147] = "XOR";
    // Returns 1 if the inputs are exactly equal, 0 otherwise.
    OpCode[OpCode["EQUAL"] = 151] = "EQUAL";
    // Returns 1 if the inputs are not equal, 0 otherwise.
    OpCode[OpCode["NOTEQUAL"] = 152] = "NOTEQUAL";
    // Arithmetic
    // Puts the sign of top stack item on top of the main stack. If value is negative, put -1; if positive, put 1; if value is zero, put 0.
    OpCode[OpCode["SIGN"] = 153] = "SIGN";
    // The input is made positive.
    OpCode[OpCode["ABS"] = 154] = "ABS";
    // The sign of the input is flipped.
    OpCode[OpCode["NEGATE"] = 155] = "NEGATE";
    // 1 is added to the input.
    OpCode[OpCode["INC"] = 156] = "INC";
    // 1 is subtracted from the input.
    OpCode[OpCode["DEC"] = 157] = "DEC";
    // a is added to b.
    OpCode[OpCode["ADD"] = 158] = "ADD";
    // b is subtracted from a.
    OpCode[OpCode["SUB"] = 159] = "SUB";
    // a is multiplied by b.
    OpCode[OpCode["MUL"] = 160] = "MUL";
    // a is divided by b.
    OpCode[OpCode["DIV"] = 161] = "DIV";
    // Returns the remainder after dividing a by b.
    OpCode[OpCode["MOD"] = 162] = "MOD";
    // The result of raising value to the exponent power.
    OpCode[OpCode["POW"] = 163] = "POW";
    // Returns the square root of a specified number.
    OpCode[OpCode["SQRT"] = 164] = "SQRT";
    // Shifts a left b bits, preserving sign.
    OpCode[OpCode["SHL"] = 168] = "SHL";
    // Shifts a right b bits, preserving sign.
    OpCode[OpCode["SHR"] = 169] = "SHR";
    // If the input is 0 or 1, it is flipped. Otherwise the output will be 0.
    OpCode[OpCode["NOT"] = 170] = "NOT";
    // If both a and b are not 0, the output is 1. Otherwise 0.
    OpCode[OpCode["BOOLAND"] = 171] = "BOOLAND";
    // If a or b is not 0, the output is 1. Otherwise 0.
    OpCode[OpCode["BOOLOR"] = 172] = "BOOLOR";
    // Returns 0 if the input is 0. 1 otherwise.
    OpCode[OpCode["NZ"] = 177] = "NZ";
    // Returns 1 if the numbers are equal, 0 otherwise.
    OpCode[OpCode["NUMEQUAL"] = 179] = "NUMEQUAL";
    // Returns 1 if the numbers are not equal, 0 otherwise.
    OpCode[OpCode["NUMNOTEQUAL"] = 180] = "NUMNOTEQUAL";
    // Returns 1 if a is less than b, 0 otherwise.
    OpCode[OpCode["LT"] = 181] = "LT";
    // Returns 1 if a is less than or equal to b, 0 otherwise.
    OpCode[OpCode["LE"] = 182] = "LE";
    // Returns 1 if a is greater than b, 0 otherwise.
    OpCode[OpCode["GT"] = 183] = "GT";
    // Returns 1 if a is greater than or equal to b, 0 otherwise.
    OpCode[OpCode["GE"] = 184] = "GE";
    // Returns the smaller of a and b.
    OpCode[OpCode["MIN"] = 185] = "MIN";
    // Returns the larger of a and b.
    OpCode[OpCode["MAX"] = 186] = "MAX";
    // Returns 1 if x is within the specified range (left-inclusive), 0 otherwise.
    OpCode[OpCode["WITHIN"] = 187] = "WITHIN";
    /* Compound-type */
    // A value n is taken from top of main stack. The next n items on main stack are removed, put inside n-sized array and this array is put on top of the main stack.
    OpCode[OpCode["PACK"] = 192] = "PACK";
    // An array is removed from top of the main stack. Its elements are put on top of the main stack (in reverse order) and the array size is also put on main stack.
    OpCode[OpCode["UNPACK"] = 193] = "UNPACK";
    // An empty array (with size 0) is put on top of the main stack.
    OpCode[OpCode["NEWARRAY0"] = 194] = "NEWARRAY0";
    // A value n is taken from top of main stack. A null-filled array with size n is put on top of the main stack.
    OpCode[OpCode["NEWARRAY"] = 195] = "NEWARRAY";
    // A value n is taken from top of main stack. An array of type T with size n is put on top of the main stack.
    OpCode[OpCode["NEWARRAY_T"] = 196] = "NEWARRAY_T";
    // An empty struct (with size 0) is put on top of the main stack.
    OpCode[OpCode["NEWSTRUCT0"] = 197] = "NEWSTRUCT0";
    // A value n is taken from top of main stack. A zero-filled struct with size n is put on top of the main stack.
    OpCode[OpCode["NEWSTRUCT"] = 198] = "NEWSTRUCT";
    // A Map is created and put on top of the main stack.
    OpCode[OpCode["NEWMAP"] = 200] = "NEWMAP";
    // An array is removed from top of the main stack. Its size is put on top of the main stack.
    OpCode[OpCode["SIZE"] = 202] = "SIZE";
    // An input index n (or key) and an array (or map) are removed from the top of the main stack. Puts True on top of main stack if array) exist, and False otherwise.
    OpCode[OpCode["HASKEY"] = 203] = "HASKEY";
    // A map is taken from top of the main stack. The keys of this map are put on top of the main stack.
    OpCode[OpCode["KEYS"] = 204] = "KEYS";
    // A map is taken from top of the main stack. The values of this map are put on top of the main stack.
    OpCode[OpCode["VALUES"] = 205] = "VALUES";
    // An input index n (or key) and an array (or map) are taken from main stack. Element array) is put on top of the main stack.
    OpCode[OpCode["PICKITEM"] = 206] = "PICKITEM";
    // The item on top of main stack is removed and appended to the second item on top of the main stack.
    OpCode[OpCode["APPEND"] = 207] = "APPEND";
    // A value v, index n (or key) and an array (or map) are taken from main stack. Attribution array=v) is performed.
    OpCode[OpCode["SETITEM"] = 208] = "SETITEM";
    // An array is removed from the top of the main stack and its elements are reversed.
    OpCode[OpCode["REVERSEITEMS"] = 209] = "REVERSEITEMS";
    // An input index n (or key) and an array (or map) are removed from the top of the main stack. Element array) is removed.
    OpCode[OpCode["REMOVE"] = 210] = "REMOVE";
    // Remove all the items from the compound-type.
    OpCode[OpCode["CLEARITEMS"] = 211] = "CLEARITEMS";
    // Remove the last element from an array and push it onto the stack.
    OpCode[OpCode["POPITEM"] = 212] = "POPITEM";
    /* Types */
    // Returns true if the input is null. Returns false otherwise.
    OpCode[OpCode["ISNULL"] = 216] = "ISNULL";
    // Returns true if the top item is of the specified type.
    OpCode[OpCode["ISTYPE"] = 217] = "ISTYPE";
    // Converts the top item to the specified type.
    OpCode[OpCode["CONVERT"] = 219] = "CONVERT";
})(OpCode || (OpCode = {}));
export function fromHex(hexstring) {
    const parsedInt = parseInt(hexstring, 16);
    if (parsedInt in OpCode) {
        return parsedInt;
    }
    throw new Error(`OpCode not found! Value: ${hexstring}`);
}
export default OpCode;
//# sourceMappingURL=OpCode.js.map