/// <reference types="node" />
import { MethodTokenLike, MethodTokenJson, MethodToken } from "./MethodToken";
export interface NEFLike {
    compiler: string;
    tokens: MethodTokenLike[];
    /** Base64 encoded string */
    script: string;
}
export interface NEFJson {
    magic: number;
    compiler: string;
    tokens: MethodTokenJson[];
    /** Base64 encoded string */
    script: string;
    checksum: number;
}
export declare class NEF {
    #private;
    private static MAX_SCRIPT_LENGTH;
    static MAGIC: number;
    compiler: string;
    tokens: MethodToken[];
    script: string;
    get checksum(): number;
    constructor(obj: Partial<NEFLike>);
    static fromJson(json: NEFJson): NEF;
    static fromBuffer(data: Buffer): NEF;
    toJson(): NEFJson;
    get size(): number;
    private serializeWithoutChecksum;
    serialize(): string;
    export(): NEFLike;
    private computeCheckSum;
}
export default NEF;
//# sourceMappingURL=NEF.d.ts.map