import { str2hexstring, sha256 } from "../u";
export var InteropServiceCode;
(function (InteropServiceCode) {
    InteropServiceCode["SYSTEM_CRYPTO_CHECKSIG"] = "56e7b327";
    InteropServiceCode["SYSTEM_CRYPTO_CHECKMULTISIG"] = "9ed0dc3a";
    InteropServiceCode["SYSTEM_BLOCKCHAIN_GETBLOCK"] = "8347922d";
    InteropServiceCode["SYSTEM_BLOCKCHAIN_GETHEIGHT"] = "7ef5721f";
    InteropServiceCode["SYSTEM_BLOCKCHAIN_GETTRANSACTION"] = "e6558d48";
    InteropServiceCode["SYSTEM_BLOCKCHAIN_GETTRANSACTIONFROMBLOCK"] = "7e56fd69";
    InteropServiceCode["SYSTEM_BLOCKCHAIN_GETTRANSACTIONHEIGHT"] = "4a3288b1";
    InteropServiceCode["SYSTEM_CALLBACK_CREATE"] = "d6a52d2a";
    InteropServiceCode["SYSTEM_CALLBACK_CREATEFROMMETHOD"] = "7c507485";
    InteropServiceCode["SYSTEM_CALLBACK_CREATEFROMSYSCALL"] = "d46efa70";
    InteropServiceCode["SYSTEM_CALLBACK_INVOKE"] = "d42b3dad";
    InteropServiceCode["SYSTEM_CONTRACT_CALL"] = "627d5b52";
    InteropServiceCode["SYSTEM_CONTRACT_CALLEX"] = "eef40cdb";
    InteropServiceCode["SYSTEM_CONTRACT_CALLNATIVE"] = "1af77b67";
    InteropServiceCode["SYSTEM_CONTRACT_CREATESTANDARDACCOUNT"] = "cf998702";
    InteropServiceCode["SYSTEM_CONTRACT_CREATEMULTISIGACCOUNT"] = "6a33e909";
    InteropServiceCode["SYSTEM_CONTRACT_GETCALLFLAGS"] = "95da3a81";
    InteropServiceCode["SYSTEM_CONTRACT_ISSTANDARD"] = "d76b9d85";
    InteropServiceCode["SYSTEM_CONTRACT_NATIVEONPERSIST"] = "2edbbc93";
    InteropServiceCode["SYSTEM_CONTRACT_NATIVEPOSTPERSIST"] = "44a15d16";
    InteropServiceCode["SYSTEM_ENUMERATOR_CONCAT"] = "d406e5e1";
    InteropServiceCode["SYSTEM_ENUMERATOR_CREATE"] = "bbaa607a";
    InteropServiceCode["SYSTEM_ENUMERATOR_NEXT"] = "926d4cf0";
    InteropServiceCode["SYSTEM_ENUMERATOR_VALUE"] = "bd20202c";
    InteropServiceCode["SYSTEM_ITERATOR_CONCAT"] = "e5870a81";
    InteropServiceCode["SYSTEM_ITERATOR_CREATE"] = "ed64f727";
    InteropServiceCode["SYSTEM_ITERATOR_KEY"] = "0e9488ba";
    InteropServiceCode["SYSTEM_ITERATOR_KEYS"] = "fd9096e9";
    InteropServiceCode["SYSTEM_ITERATOR_VALUES"] = "beee30ad";
    InteropServiceCode["SYSTEM_RUNTIME_BURNGAS"] = "c35a8cbc";
    InteropServiceCode["SYSTEM_RUNTIME_CHECKWITNESS"] = "f827ec8c";
    InteropServiceCode["SYSTEM_RUNTIME_GASLEFT"] = "1488d8ce";
    InteropServiceCode["SYSTEM_RUNTIME_GETCALLINGSCRIPTHASH"] = "39536e3c";
    InteropServiceCode["SYSTEM_RUNTIME_GETENTRYSCRIPTHASH"] = "f9b4e238";
    InteropServiceCode["SYSTEM_RUNTIME_GETEXECUTINGSCRIPTHASH"] = "dbfea874";
    InteropServiceCode["SYSTEM_RUNTIME_GETINVOCATIONCOUNTER"] = "84271143";
    InteropServiceCode["SYSTEM_RUNTIME_GETNOTIFICATIONS"] = "274335f1";
    InteropServiceCode["SYSTEM_RUNTIME_GETSCRIPTCONTAINER"] = "2d510830";
    InteropServiceCode["SYSTEM_RUNTIME_GETTIME"] = "b7c38803";
    InteropServiceCode["SYSTEM_RUNTIME_GETTRIGGER"] = "e97d38a0";
    InteropServiceCode["SYSTEM_RUNTIME_LOG"] = "cfe74796";
    InteropServiceCode["SYSTEM_RUNTIME_NOTIFY"] = "95016f61";
    InteropServiceCode["SYSTEM_RUNTIME_PLATFORM"] = "b279fcf6";
    InteropServiceCode["SYSTEM_STORAGE_ASREADONLY"] = "764cbfe9";
    InteropServiceCode["SYSTEM_STORAGE_DELETE"] = "2f58c5ed";
    InteropServiceCode["SYSTEM_STORAGE_FIND"] = "df30b89a";
    InteropServiceCode["SYSTEM_STORAGE_GET"] = "925de831";
    InteropServiceCode["SYSTEM_STORAGE_GETCONTEXT"] = "9bf667ce";
    InteropServiceCode["SYSTEM_STORAGE_GETREADONLYCONTEXT"] = "f6b46be2";
    InteropServiceCode["SYSTEM_STORAGE_PUT"] = "e63f1884";
})(InteropServiceCode || (InteropServiceCode = {}));
export default InteropServiceCode;
export function generateInteropServiceCode(methodName) {
    const hexMethodName = str2hexstring(methodName);
    return sha256(hexMethodName).slice(0, 8);
}
export function fromMethodName(methodName) {
    const enumName = methodName.toUpperCase().replace(".", "_");
    if (enumName in InteropServiceCode) {
        return InteropServiceCode[enumName];
    }
    throw new Error("Method name not found in InteropServiceCode!");
}
//# sourceMappingURL=InteropServiceCode.js.map