import { StackItemJson } from "../sc";
import { InvokeResult } from "./Query";
export declare type StackItemParser = (item: StackItemJson) => unknown;
export declare type VMResultParser = (result: InvokeResult) => unknown[];
/**
 * Builds a parser to parse the results of the stack.
 * @param args - A list of functions to parse arguments. Each function is mapped to its corresponding StackItem in the result.
 * @returns parser function
 */
export declare function buildParser(...args: StackItemParser[]): VMResultParser;
/**
 * This just returns the value of the StackItem.
 */
export declare function NoOpParser(item: StackItemJson): unknown;
/**
 * Parses the result to an integer.
 */
export declare function IntegerParser(item: StackItemJson): number;
/**
 *  Parses the result to a ASCII string.
 */
export declare function StringParser(item: StackItemJson): string;
/**
 * Parses the result to a Fixed8.
 */
export declare function Fixed8Parser(item: StackItemJson): number;
/**
 * Parses the VM Stack and returns human readable strings. The types are inferred based on the StackItem type.
 * @param res - RPC Response
 * @returns Array of results
 */
export declare function SimpleParser(res: InvokeResult): unknown[];
//# sourceMappingURL=parse.d.ts.map