import { Query, RPCResponse, RPCErrorResponse } from "../Query";
export interface RpcConfig {
    timeout?: number;
}
export declare type GConstructor<T = {}> = new (...args: any[]) => T;
export declare type RpcDispatcherMixin = GConstructor<RpcDispatcher>;
export declare function sendQuery<TResponse>(url: string, query: Query<unknown[], TResponse>, config?: RpcConfig): Promise<RPCResponse<TResponse>>;
/**
 * Basic JSON-RPC 2.0 Dispatcher. Contains the basic infrastructure to send out JSON-RPC 2.0 methods.
 * Client interfaces should accept this RpcDispatcher as a constructor parameter.
 *
 * @example
 *
 * ```ts
 * const dispatcher = new RpcDispatcher("http://www.example.com");
 * const result = await dispatcher.execute(new Query({"method": "listplugins"}));
 * ```
 */
export declare class RpcDispatcher {
    url: string;
    constructor(url: string);
    /**
     * Takes an Query object and executes it. Throws if error is encountered.
     */
    execute<TResponse>(query: Query<unknown[], TResponse>, config?: RpcConfig): Promise<TResponse>;
}
export declare class RpcError extends Error {
    code: number;
    constructor(errResponse: RPCErrorResponse);
}
//# sourceMappingURL=RpcDispatcher.d.ts.map