import { Query, } from "../Query";
import { RpcDispatcher } from "./RpcDispatcher";
// eslint-disable-next-line @typescript-eslint/explicit-function-return-type, @typescript-eslint/explicit-module-boundary-types
export function Nep17TrackerRpcMixin(base) {
    return class Nep17TrackerRpcInterface extends base {
        async getNep17Transfers(accountIdentifier, startTime, endTime) {
            return this.execute(Query.getNep17Transfers(accountIdentifier, startTime, endTime));
        }
        async getNep17Balances(accountIdentifier) {
            return this.execute(Query.getNep17Balances(accountIdentifier));
        }
    };
}
export class Nep17TrackerRpcClient extends Nep17TrackerRpcMixin(RpcDispatcher) {
    get [Symbol.toStringTag]() {
        return `Nep17TrackerRpcClient(${this.url})`;
    }
}
//# sourceMappingURL=Nep17TrackerRpcClient.js.map