import { Transaction, Signer, SignerJson } from "../../tx";
import { Query, CliPlugin, GetPeersResult, GetRawMemPoolResult, GetRawTransactionResult, InvokeResult, GetVersionResult, GetContractStateResult } from "../Query";
import { BlockJson, BlockHeaderJson, Validator } from "../../types";
import { RpcDispatcher, RpcDispatcherMixin } from "./RpcDispatcher";
import { HexString } from "../../u";
export declare function NeoServerRpcMixin<TBase extends RpcDispatcherMixin>(base: TBase): {
    new (...args: any[]): {
        /**
         * Get the latest block hash.
         */
        getBestBlockHash(): Promise<string>;
        /**
         * Gets the block at a given height or hash.
         * @param indexOrHash - height or hash of desired block;
         * @param verbose - 0 for serialized block in hex, 1 for json format, defaults to 0
         * @returns string or block object according to verbose
         */
        getBlock(indexOrHash: number | string, verbose?: false | 0 | undefined): Promise<string>;
        /**
         * Gets the block at a given height or hash.
         * @param indexOrHash - height or hash of desired block;
         * @param verbose - 0 for serialized block in hex, 1 for json format, defaults to 0
         * @returns string or block object according to verbose
         */
        getBlock(indexOrHash: number | string, verbose: 1 | true): Promise<BlockJson>;
        /**
         * Gets the block hash at a given height.
         */
        getBlockHash(index: number): Promise<string>;
        /**
         * Get the current block height.
         */
        getBlockCount(): Promise<number>;
        /**
         * Get the corresponding block header information according to the specified script hash.
         * @param indexOrHash - height or hash of desired block
         * @param verbose - 0 for serialized block in hex, 1 for json format, defaults to 0
         * @returns verbose = 0, blocker header hex string; verbose = 1, block header info in json
         */
        getBlockHeader(indexOrHash: number | string, verbose?: 0 | undefined): Promise<string>;
        /**
         * Get the corresponding block header information according to the specified script hash.
         * @param indexOrHash - height or hash of desired block
         * @param verbose - 0 for serialized block in hex, 1 for json format, defaults to 0
         * @returns verbose = 0, blocker header hex string; verbose = 1, block header info in json
         */
        getBlockHeader(indexOrHash: number | string, verbose: 1): Promise<BlockHeaderJson>;
        /**
         * Get the list of public keys in the committee.
         */
        getCommittee(): Promise<string[]>;
        /**
         * Gets the state of the contract at the given scriptHash.
         */
        getContractState(scriptHash: string): Promise<GetContractStateResult>;
        /**
         * This Query returns the transaction hashes of the transactions confirmed or unconfirmed.
         * @param shouldGetUnverified - shouldGetUnverified Optional. Default is 0.
         * shouldGetUnverified = 0, get confirmed transaction hashes
         * shouldGetUnverified = 1, get current block height and confirmed and unconfirmed tx hash
         */
        getRawMemPool(shouldGetUnverified?: false | 0 | undefined): Promise<string[]>;
        /**
         * This Query returns the transaction hashes of the transactions confirmed or unconfirmed.
         * @param shouldGetUnverified - shouldGetUnverified Optional. Default is 0.
         * shouldGetUnverified = 0, get confirmed transaction hashes
         * shouldGetUnverified = 1, get current block height and confirmed and unconfirmed tx hash
         */
        getRawMemPool(shouldGetUnverified: 1 | true): Promise<GetRawMemPoolResult>;
        /**
         * Gets a transaction based on its hash.
         * @param txid - transaction id
         * @param verbose - 0, will query transaction in hex string; 1 will query for transaction object. defaults to 0
         * @returns transaction hex or object
         */
        getRawTransaction(txid: string, verbose?: false | 0 | undefined): Promise<string>;
        /**
         * Gets a transaction based on its hash.
         * @param txid - transaction id
         * @param verbose - 0, will query transaction in hex string; 1 will query for transaction object. defaults to 0
         * @returns transaction hex or object
         */
        getRawTransaction(txid: string, verbose: 1 | true): Promise<GetRawTransactionResult>;
        /**
         * Gets the corresponding value of a key in the storage of a contract address.
         */
        getStorage(scriptHash: string, key: string): Promise<string>;
        /**
         * Gets the block index in which the transaction is found.
         * @param txid - hash of the specific transaction.
         */
        getTransactionHeight(txid: string): Promise<number>;
        /**
         * Gets the number of peers this node is connected to.
         */
        getConnectionCount(): Promise<number>;
        /**
         * Gets the list of validators available for voting.
         */
        getNextBlockValidators(): Promise<Validator[]>;
        /**
         * Gets a list of all peers that this node has discovered.
         */
        getPeers(): Promise<GetPeersResult>;
        /**
         * Gets the version of the NEO node along with various other metadata.
         */
        getVersion(): Promise<GetVersionResult>;
        /**
         * Sends a serialized transaction to the network.
         * @returns transaction id
         */
        sendRawTransaction(transaction: Transaction | string | HexString): Promise<string>;
        /**
         * Submits a serialized block to the network.
         * @returns block hash if success
         */
        submitBlock(block: string): Promise<string>;
        /**
         * Get the amount of unclaimed GAS for a NEO address. This is returned as the raw value. To get the display value, divide this by 100000000.
         */
        getUnclaimedGas(addr: string): Promise<string>;
        /**
         * Submits a verification script to run under a contract.
         * @param scriptHash - contract to test
         * @param args - arguments to pass
         * @param signers - Signers to be included in transaction
         */
        invokeContractVerify(scriptHash: string, args: unknown[], signers?: (Signer | SignerJson)[]): Promise<InvokeResult>;
        /**
         * Submits a contract method call with parameters for the node to run. This method is a local invoke, results are not reflected on the blockchain.
         */
        invokeFunction(scriptHash: string, operation: string, params?: unknown[], signers?: (Signer | SignerJson)[]): Promise<InvokeResult>;
        /**
         * Submits a script for the node to run. This method is a local invoke, results are not reflected on the blockchain.
         *
         * @param script - base64-encoded hexstring.
         * @param signers - signatures accompanying this execution.
         */
        invokeScript(script: string | HexString, signers?: (Signer | SignerJson)[]): Promise<InvokeResult>;
        /**
         * Returns a list of plugins loaded by the node.
         */
        listPlugins(): Promise<CliPlugin[]>;
        /**
         * Checks if the provided address is a valid NEO address.
         */
        validateAddress(addr: string): Promise<boolean>;
        url: string;
        execute<TResponse>(query: Query<unknown[], TResponse>, config?: import("./RpcDispatcher").RpcConfig | undefined): Promise<TResponse>;
    };
} & TBase;
declare const NeoServerRpcClient_base: {
    new (...args: any[]): {
        /**
         * Get the latest block hash.
         */
        getBestBlockHash(): Promise<string>;
        /**
         * Gets the block at a given height or hash.
         * @param indexOrHash - height or hash of desired block;
         * @param verbose - 0 for serialized block in hex, 1 for json format, defaults to 0
         * @returns string or block object according to verbose
         */
        getBlock(indexOrHash: string | number, verbose?: false | 0 | undefined): Promise<string>;
        /**
         * Gets the block at a given height or hash.
         * @param indexOrHash - height or hash of desired block;
         * @param verbose - 0 for serialized block in hex, 1 for json format, defaults to 0
         * @returns string or block object according to verbose
         */
        getBlock(indexOrHash: string | number, verbose: true | 1): Promise<BlockJson>;
        /**
         * Gets the block hash at a given height.
         */
        getBlockHash(index: number): Promise<string>;
        /**
         * Get the current block height.
         */
        getBlockCount(): Promise<number>;
        /**
         * Get the corresponding block header information according to the specified script hash.
         * @param indexOrHash - height or hash of desired block
         * @param verbose - 0 for serialized block in hex, 1 for json format, defaults to 0
         * @returns verbose = 0, blocker header hex string; verbose = 1, block header info in json
         */
        getBlockHeader(indexOrHash: string | number, verbose?: 0 | undefined): Promise<string>;
        /**
         * Get the corresponding block header information according to the specified script hash.
         * @param indexOrHash - height or hash of desired block
         * @param verbose - 0 for serialized block in hex, 1 for json format, defaults to 0
         * @returns verbose = 0, blocker header hex string; verbose = 1, block header info in json
         */
        getBlockHeader(indexOrHash: string | number, verbose: 1): Promise<BlockHeaderJson>;
        /**
         * Get the list of public keys in the committee.
         */
        getCommittee(): Promise<string[]>;
        /**
         * Gets the state of the contract at the given scriptHash.
         */
        getContractState(scriptHash: string): Promise<GetContractStateResult>;
        /**
         * This Query returns the transaction hashes of the transactions confirmed or unconfirmed.
         * @param shouldGetUnverified - shouldGetUnverified Optional. Default is 0.
         * shouldGetUnverified = 0, get confirmed transaction hashes
         * shouldGetUnverified = 1, get current block height and confirmed and unconfirmed tx hash
         */
        getRawMemPool(shouldGetUnverified?: false | 0 | undefined): Promise<string[]>;
        /**
         * This Query returns the transaction hashes of the transactions confirmed or unconfirmed.
         * @param shouldGetUnverified - shouldGetUnverified Optional. Default is 0.
         * shouldGetUnverified = 0, get confirmed transaction hashes
         * shouldGetUnverified = 1, get current block height and confirmed and unconfirmed tx hash
         */
        getRawMemPool(shouldGetUnverified: true | 1): Promise<GetRawMemPoolResult>;
        /**
         * Gets a transaction based on its hash.
         * @param txid - transaction id
         * @param verbose - 0, will query transaction in hex string; 1 will query for transaction object. defaults to 0
         * @returns transaction hex or object
         */
        getRawTransaction(txid: string, verbose?: false | 0 | undefined): Promise<string>;
        /**
         * Gets a transaction based on its hash.
         * @param txid - transaction id
         * @param verbose - 0, will query transaction in hex string; 1 will query for transaction object. defaults to 0
         * @returns transaction hex or object
         */
        getRawTransaction(txid: string, verbose: true | 1): Promise<GetRawTransactionResult>;
        /**
         * Gets the corresponding value of a key in the storage of a contract address.
         */
        getStorage(scriptHash: string, key: string): Promise<string>;
        /**
         * Gets the block index in which the transaction is found.
         * @param txid - hash of the specific transaction.
         */
        getTransactionHeight(txid: string): Promise<number>;
        /**
         * Gets the number of peers this node is connected to.
         */
        getConnectionCount(): Promise<number>;
        /**
         * Gets the list of validators available for voting.
         */
        getNextBlockValidators(): Promise<Validator[]>;
        /**
         * Gets a list of all peers that this node has discovered.
         */
        getPeers(): Promise<GetPeersResult>;
        /**
         * Gets the version of the NEO node along with various other metadata.
         */
        getVersion(): Promise<GetVersionResult>;
        /**
         * Sends a serialized transaction to the network.
         * @returns transaction id
         */
        sendRawTransaction(transaction: string | HexString | Transaction): Promise<string>;
        /**
         * Submits a serialized block to the network.
         * @returns block hash if success
         */
        submitBlock(block: string): Promise<string>;
        /**
         * Get the amount of unclaimed GAS for a NEO address. This is returned as the raw value. To get the display value, divide this by 100000000.
         */
        getUnclaimedGas(addr: string): Promise<string>;
        /**
         * Submits a verification script to run under a contract.
         * @param scriptHash - contract to test
         * @param args - arguments to pass
         * @param signers - Signers to be included in transaction
         */
        invokeContractVerify(scriptHash: string, args: unknown[], signers?: (Signer | SignerJson)[]): Promise<InvokeResult>;
        /**
         * Submits a contract method call with parameters for the node to run. This method is a local invoke, results are not reflected on the blockchain.
         */
        invokeFunction(scriptHash: string, operation: string, params?: unknown[], signers?: (Signer | SignerJson)[]): Promise<InvokeResult>;
        /**
         * Submits a script for the node to run. This method is a local invoke, results are not reflected on the blockchain.
         *
         * @param script - base64-encoded hexstring.
         * @param signers - signatures accompanying this execution.
         */
        invokeScript(script: string | HexString, signers?: (Signer | SignerJson)[]): Promise<InvokeResult>;
        /**
         * Returns a list of plugins loaded by the node.
         */
        listPlugins(): Promise<CliPlugin[]>;
        /**
         * Checks if the provided address is a valid NEO address.
         */
        validateAddress(addr: string): Promise<boolean>;
        url: string;
        execute<TResponse>(query: Query<unknown[], TResponse>, config?: import("./RpcDispatcher").RpcConfig | undefined): Promise<TResponse>;
    };
} & typeof RpcDispatcher;
/**
 * RPC Client model to query a NEO node. Contains built-in methods to query using RPC calls.
 */
export declare class NeoServerRpcClient extends NeoServerRpcClient_base {
    get [Symbol.toStringTag](): string;
}
export {};
//# sourceMappingURL=NeoServerRpcClient.d.ts.map