import Query from "../Query";
import { RpcDispatcher } from "./RpcDispatcher";
// eslint-disable-next-line @typescript-eslint/explicit-function-return-type, @typescript-eslint/explicit-module-boundary-types
export function ApplicationLogsRpcMixin(base) {
    return class extends base {
        async getApplicationLog(blockOrTxHash) {
            return await this.execute(Query.getApplicationLog(blockOrTxHash));
        }
    };
}
export class ApplicationLogsRpcClient extends ApplicationLogsRpcMixin(RpcDispatcher) {
    get [Symbol.toStringTag]() {
        return `ApplicationLogsRpcClient(${this.url})`;
    }
}
//# sourceMappingURL=ApplicationLogsRpcClient.js.map