import { RpcDispatcher } from "./clients";
import { Query } from "./Query";
declare const FullRpcClient_base: {
    new (...args: any[]): {
        getNep17Transfers(accountIdentifier: string, startTime?: string | undefined, endTime?: string | undefined): Promise<import("./Query").GetNep17TransfersResult>;
        getNep17Balances(accountIdentifier: string): Promise<import("./Query").GetNep17BalancesResult>;
        url: string;
        execute<TResponse>(query: Query<unknown[], TResponse>, config?: import("./clients").RpcConfig | undefined): Promise<TResponse>;
    };
} & {
    new (...args: any[]): {
        getApplicationLog(blockOrTxHash: string): Promise<import("./Query").ApplicationLogJson>;
        url: string;
        execute<TResponse>(query: Query<unknown[], TResponse>, config?: import("./clients").RpcConfig | undefined): Promise<TResponse>;
    };
} & {
    new (...args: any[]): {
        getBestBlockHash(): Promise<string>;
        getBlock(indexOrHash: string | number, verbose?: false | 0 | undefined): Promise<string>;
        getBlock(indexOrHash: string | number, verbose: true | 1): Promise<import("../types").BlockJson>;
        getBlockHash(index: number): Promise<string>;
        getBlockCount(): Promise<number>;
        getBlockHeader(indexOrHash: string | number, verbose?: 0 | undefined): Promise<string>;
        getBlockHeader(indexOrHash: string | number, verbose: 1): Promise<import("../types").BlockHeaderJson>;
        getCommittee(): Promise<string[]>;
        getContractState(scriptHash: string): Promise<import("./Query").GetContractStateResult>;
        getRawMemPool(shouldGetUnverified?: false | 0 | undefined): Promise<string[]>;
        getRawMemPool(shouldGetUnverified: true | 1): Promise<import("./Query").GetRawMemPoolResult>;
        getRawTransaction(txid: string, verbose?: false | 0 | undefined): Promise<string>;
        getRawTransaction(txid: string, verbose: true | 1): Promise<import("./Query").GetRawTransactionResult>;
        getStorage(scriptHash: string, key: string): Promise<string>;
        getTransactionHeight(txid: string): Promise<number>;
        getConnectionCount(): Promise<number>;
        getNextBlockValidators(): Promise<import("../types").Validator[]>;
        getPeers(): Promise<import("./Query").GetPeersResult>;
        getVersion(): Promise<import("./Query").GetVersionResult>;
        sendRawTransaction(transaction: string | import("../u").HexString | import("../tx").Transaction): Promise<string>;
        submitBlock(block: string): Promise<string>;
        getUnclaimedGas(addr: string): Promise<string>;
        invokeContractVerify(scriptHash: string, args: unknown[], signers?: (import("../tx").Signer | import("../tx").SignerJson)[]): Promise<import("./Query").InvokeResult>;
        invokeFunction(scriptHash: string, operation: string, params?: unknown[], signers?: (import("../tx").Signer | import("../tx").SignerJson)[]): Promise<import("./Query").InvokeResult>;
        invokeScript(script: string | import("../u").HexString, signers?: (import("../tx").Signer | import("../tx").SignerJson)[]): Promise<import("./Query").InvokeResult>;
        listPlugins(): Promise<import("./Query").CliPlugin[]>;
        validateAddress(addr: string): Promise<boolean>;
        url: string;
        execute<TResponse>(query: Query<unknown[], TResponse>, config?: import("./clients").RpcConfig | undefined): Promise<TResponse>;
    };
} & typeof RpcDispatcher;
declare class FullRpcClient extends FullRpcClient_base {
    get [Symbol.toStringTag](): string;
}
/**
 * RPC Client model to query a NEO node. Contains built-in methods to query using RPC calls.
 */
export declare class RPCClient extends FullRpcClient {
    net: string;
    history: Query<unknown[], unknown>[];
    lastSeenHeight: number;
    private _latencies;
    /**
     * @param net - A url pointing to a NEO RPC node.
     * @param version - version of NEO node. Used to check if RPC methods have been implemented. it will default to DEFAULT_RPC found in CONST
     */
    constructor(net: string);
    get [Symbol.toStringTag](): string;
    get latency(): number;
    set latency(lat: number);
    /**
     * Measures the latency using getBlockCount call. Returns the current latency. For average, call this.latency
     */
    ping(): Promise<number>;
}
export default RPCClient;
//# sourceMappingURL=RPCClient.d.ts.map