import { NeonObject } from "../model";
export interface ProtocolLike {
    magic: number;
    addressVersion: number;
    standbyValidators: string[];
    seedList: string[];
}
/**
 * This is the ProtocolConfiguration field found in protocol.json
 */
export interface ProtocolJSON {
    Magic: number;
    AddressVersion: number;
    StandbyValidators: string[];
    SeedList: string[];
}
/**
 * Model of the protocol configuration file used by the C# implementation.
 */
export declare class Protocol implements NeonObject<ProtocolLike> {
    magic: number;
    addressVersion: number;
    standbyValidators: string[];
    seedList: string[];
    constructor(config?: Partial<ProtocolLike & ProtocolJSON>);
    get [Symbol.toStringTag](): string;
    export(): ProtocolLike;
    toConfiguration(): ProtocolJSON;
    equals(other: Partial<ProtocolLike & ProtocolJSON>): boolean;
}
export default Protocol;
//# sourceMappingURL=Protocol.d.ts.map